/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editor;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBreadcrumbsProvider
implements BreadcrumbsProvider {
    public Language[] getLanguages() {
        return new Language[]{JavascriptLanguage.INSTANCE, JavaScriptSupportLoader.TYPESCRIPT};
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        JSQualifiedNamedElement assignedTo;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider", "acceptElement"));
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        return !(element instanceof JSExpression) || (assignedTo = JSPsiImplUtils.getInitializedElement((JSExpression)element)) == null;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element) {
        JSExpression expression;
        String referenceName;
        JSExpression methodExpression;
        PsiElement callExpr;
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider", "getElementInfo"));
        }
        if (element instanceof JSFunctionExpression && ((JSFunctionExpression)element).getName() == null && (parent = element.getParent()) instanceof JSArgumentList && (callExpr = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)callExpr).getMethodExpression()) instanceof JSReferenceExpression && (referenceName = ((JSReferenceExpression)methodExpression).getReferenceName()) != null) {
            String string = JSBundle.message((String)"js.breadcrumbs.callback.for", (Object[])new Object[]{referenceName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider", "getElementInfo"));
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        String name = null;
        if (!(!(element instanceof JSDefinitionExpression) || (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSThisExpression)) {
            name = ((JSDefinitionExpression)element).getQualifiedName();
        }
        if (name == null) {
            name = ((JSQualifiedNamedElement)element).getName();
        }
        if (name == null) {
            name = "<anonymous>";
        }
        builder.append(name);
        if (element instanceof JSFunction || element instanceof JSInitializerOwner && ((JSInitializerOwner)element).getInitializer() instanceof JSFunction) {
            builder.append("()");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider", "getElementInfo"));
        }
        return string;
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider", "getElementIcon"));
        }
        return null;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider", "getElementTooltip"));
        }
        return null;
    }

    @Nullable
    public PsiElement getParent(@NotNull PsiElement element) {
        JSQualifiedNamedElement initializedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider", "getParent"));
        }
        if (element instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)element)) instanceof JSDefinitionExpression) {
            return initializedElement;
        }
        return element.getParent();
    }
}

