/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLineWrapPositionStrategy
implements LineWrapPositionStrategy {
    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean virtual) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/formatter/JSLineWrapPositionStrategy", "calculateWrapPosition"));
        }
        if (virtual) {
            LineWrapPositionStrategy implementation = LanguageLineWrapPositionStrategy.INSTANCE.getDefaultImplementation();
            return implementation.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, true);
        }
        return JSLineWrapPositionStrategy.calcWrapPosition(document, project, maxPreferredOffset);
    }

    private static int calcWrapPosition(@NotNull Document document, @Nullable Project project, int wrapOffset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/formatter/JSLineWrapPositionStrategy", "calcWrapPosition"));
        }
        if (project != null) {
            PsiElement currElement;
            PsiElement elementToWrap;
            PsiFile file;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            if (documentManager.isUncommited(document)) {
                documentManager.commitDocument(document);
            }
            if ((file = documentManager.getPsiFile(document)) != null && (elementToWrap = JSLineWrapPositionStrategy.getElementToWrapAsText(currElement = file.findElementAt(wrapOffset))) != null) {
                return JSLineWrapPositionStrategy.getCommentWrapPos(elementToWrap, wrapOffset);
            }
        }
        return -1;
    }

    @Nullable
    private static PsiElement getElementToWrapAsText(@Nullable PsiElement element) {
        if (element != null) {
            if (element instanceof PsiComment || element.getNode().getElementType() == JSTokenTypes.STRING_LITERAL) {
                return element;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSDocComment) {
                return parent;
            }
        }
        return null;
    }

    private static int getCommentWrapPos(@NotNull PsiElement elementToWrap, int wrapOffset) {
        if (elementToWrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToWrap", "com/intellij/lang/javascript/formatter/JSLineWrapPositionStrategy", "getCommentWrapPos"));
        }
        CharSequence chars = elementToWrap.getNode().getChars();
        int startOffset = elementToWrap.getTextRange().getStartOffset();
        int lastSpaceStart = -1;
        int prev = 0;
        for (int i = 0; i < chars.length() && i < wrapOffset - startOffset; ++i) {
            char c = chars.charAt(i);
            if ((c == ' ' || c == '\t') && prev != 32 && prev != 9) {
                lastSpaceStart = i;
            }
            prev = c;
        }
        if (lastSpaceStart > 2) {
            return startOffset + lastSpaceStart;
        }
        return -1;
    }
}

