/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactAttributeDescriptor
extends BasicXmlAttributeDescriptor
implements PsiPresentableMetaData {
    private final String myAttributeName;
    @Nullable
    private final PsiElement myDeclaration;
    private boolean myForceOptional;

    private ReactAttributeDescriptor(String attributeName, @Nullable PsiElement declaration, boolean forceOptional) {
        this.myAttributeName = attributeName;
        this.myDeclaration = declaration;
        this.myForceOptional = forceOptional;
    }

    @NotNull
    public static XmlAttributeDescriptor create(String name, PsiElement declaration, boolean forceOptional) {
        HtmlAttributeDescriptorImpl htmlAttributeDescriptorImpl = new HtmlAttributeDescriptorImpl((XmlAttributeDescriptor)new ReactAttributeDescriptor(name, declaration, forceOptional), true);
        if (htmlAttributeDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptor", "create"));
        }
        return htmlAttributeDescriptorImpl;
    }

    public boolean isRequired() {
        if (this.myForceOptional) {
            return false;
        }
        PsiElement declaration = this.getDeclaration();
        if (declaration instanceof JSImplicitElement) {
            return "r".equals(((JSImplicitElement)declaration).getUserString());
        }
        if (declaration instanceof TypeScriptPropertySignature) {
            return !((TypeScriptPropertySignature)declaration).isOptional();
        }
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public boolean isEnumerated() {
        String[] values = this.getEnumeratedValues();
        return values != null && values.length > 0;
    }

    protected PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        return xmlElement;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myDeclaration;
    }

    public String getName() {
        return this.myAttributeName;
    }

    public void init(PsiElement element) {
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactAttributeDescriptor", "getDependences"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isFixed() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    public String[] getEnumeratedValues() {
        PsiElement declaration = this.getDeclaration();
        if (declaration instanceof JSImplicitElement && "Boolean".equals(((JSImplicitElement)declaration).getTypeString())) {
            return new String[]{this.myAttributeName};
        }
        if (declaration instanceof TypeScriptPropertySignature && ((TypeScriptPropertySignature)declaration).getType() instanceof JSBooleanType) {
            return new String[]{this.myAttributeName};
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getTypeName() {
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }
}

