/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.frameworks.webpack.WebpackInJavaScriptJsonSchemaProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.json.ProxyingAnnotationHolder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotator;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import org.jetbrains.annotations.NotNull;

public class WebpackConfigHighlightingInspection
extends JSInspection {
    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSBundle.message((String)"js.webpack.config.highlighting.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        final JsonSchemaObject schemaObject = JsonSchemaService.Impl.get((Project)holder.getProject()).getSchemaObjectForSchemaFile(WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile());
        if (schemaObject == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection", "createVisitor"));
            }
            return psiElementVisitor;
        }
        AnnotationSession annotationSession = new AnnotationSession(session.getFile());
        final ProxyingAnnotationHolder annotationHolder = ProxyingAnnotationHolder.getOrCreate(annotationSession, holder, "webpack: ", "JavaScript.WebPack");
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSElement(JSElement element) {
                if (WebpackInJavaScriptJsonSchemaProvider.isApplicable((PsiElement)element)) {
                    new JsonSchemaAnnotator.Worker(schemaObject, (AnnotationHolder)annotationHolder, JsonLikePsiWalker.getWalker((PsiElement)element, (JsonSchemaObject)schemaObject)).annotate((PsiElement)element);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

