/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.imports.ES6ImportOptimizer;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowImportOptimizer
extends ES6ImportOptimizer {
    @Override
    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.isFlow;
    }

    private static boolean isTypeImport(@NotNull ES6UnusedImportsHelper.UnusedInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "isTypeImport"));
        }
        return FlowImportOptimizer.checkKeyword(info, JSTokenTypes.TYPE_KEYWORD);
    }

    private static boolean isTypeOfImport(@NotNull ES6UnusedImportsHelper.UnusedInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "isTypeOfImport"));
        }
        return FlowImportOptimizer.checkKeyword(info, JSTokenTypes.TYPEOF_KEYWORD);
    }

    private static boolean checkKeyword(@NotNull ES6UnusedImportsHelper.UnusedInfo info, IElementType token) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "checkKeyword"));
        }
        ES6ImportDeclaration declaration = info.getDeclaration();
        return declaration.getNode().findChildByType(token) != null;
    }

    @Override
    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "getImportPrefix"));
        }
        ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem(imports);
        if (item == null) {
            String string = super.getImportPrefix(imports);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "getImportPrefix"));
            }
            return string;
        }
        if (FlowImportOptimizer.isTypeImport(item)) {
            if ("import type " == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "getImportPrefix"));
            }
            return "import type ";
        }
        if (FlowImportOptimizer.isTypeOfImport(item)) {
            if ("import typeof " == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "getImportPrefix"));
            }
            return "import typeof ";
        }
        String string = super.getImportPrefix(imports);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "getImportPrefix"));
        }
        return string;
    }

    @Override
    protected void processMergedImports(@NotNull PsiFile file, @Nullable Document document, List<String> importsResult, String fromText, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/imports/FlowImportOptimizer", "processMergedImports"));
        }
        ArrayList types = ContainerUtil.newArrayList();
        ArrayList typeOf = ContainerUtil.newArrayList();
        ArrayList simple = ContainerUtil.newArrayList();
        for (ES6UnusedImportsHelper.UnusedInfo anImport : mergedImports) {
            ArrayList current = simple;
            if (FlowImportOptimizer.isTypeImport(anImport)) {
                current = types;
            }
            if (FlowImportOptimizer.isTypeOfImport(anImport)) {
                current = typeOf;
            }
            current.add(anImport);
        }
        if (!types.isEmpty()) {
            super.processMergedImports(file, document, importsResult, fromText, types);
        }
        if (!typeOf.isEmpty()) {
            super.processMergedImports(file, document, importsResult, fromText, typeOf);
        }
        if (!simple.isEmpty()) {
            super.processMergedImports(file, document, importsResult, fromText, simple);
        }
    }
}

