/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSSharedUsageInformation;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JSUnusedLocalSymbolsInspection
extends JSInspection {
    public boolean myIgnoreUnusedFunctionParameters;
    public boolean myIgnoreUnusedCatchParameters = true;
    public static final String SHORT_NAME = JSUnusedLocalSymbolsInspection.calcShortNameFromClass(JSUnusedLocalSymbolsInspection.class);
    private static Key<Map<ProblemsHolder, Map<PsiElement, Map<JSNamedElement, Boolean>>>> ourUnusedScopeMapKey = Key.create((String)"js.unusedMap");

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.local.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)node, session, holder);
            }

            public void visitJSParameter(JSParameter node) {
                JSNamespaceEvaluationResult ns;
                String className;
                if (!JSUnusedLocalSymbolsInspection.this.isLocallyDefined((JSNamedElement)node, (PsiElement)JSUnusedLocalSymbolsInspection.getScopeNode((JSNamedElement)node))) {
                    return;
                }
                if (TypeScriptPsiUtil.isFieldParameter(node)) {
                    this.checkUsagesPrivateField(node);
                    return;
                }
                if (TypeScriptPsiUtil.isThisParameter((JSParameterItem)node)) {
                    return;
                }
                PsiElement scopeNode = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, JSCatchBlock.class});
                if (scopeNode == null || scopeNode instanceof JSCatchBlock && JSUnusedLocalSymbolsInspection.this.myIgnoreUnusedCatchParameters) {
                    return;
                }
                if (scopeNode instanceof JSFunction && (className = JSNamespaceEvaluationResult.getQualifiedName(ns = JSContextResolver.resolveContext((PsiElement)node))) != null && JSSymbolUtil.isInterface(className, (PsiElement)node)) {
                    return;
                }
                Map unusedParametersStatus = JSUnusedLocalSymbolsInspection.this.getUnusedDeclarationsMap(scopeNode, session, holder);
                if (unusedParametersStatus == null) {
                    return;
                }
                JSUnusedLocalSymbolsInspection.this.addUnusedElementIfNotUsedBefore((JSNamedElement)node, unusedParametersStatus);
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)node.getProject());
                List injectedFiles = injectedLanguageManager.getInjectedPsiFiles((PsiElement)node);
                if (!ContainerUtil.isEmpty((Collection)injectedFiles)) {
                    for (Pair pair : injectedFiles) {
                        final 1 inspectionVisitor = this;
                        if (!(pair.first instanceof JSFile)) continue;
                        ((PsiElement)pair.first).accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                            public void visitElement(PsiElement element) {
                                if (element instanceof JSReferenceExpression || element instanceof JSDocTagValue) {
                                    element.accept((PsiElementVisitor)inspectionVisitor);
                                }
                                super.visitElement(element);
                            }
                        });
                    }
                    return;
                }
                for (PsiReference ref : node.getReferences()) {
                    if (ref instanceof CssReference || ref instanceof JSModuleBaseReference) continue;
                    if (ref instanceof PsiPolyVariantReference) {
                        this.registerReferencedFromReferences(((PsiPolyVariantReference)ref).multiResolve(false), ref);
                        continue;
                    }
                    this.registerReferencedFromReference(ref.resolve(), ref);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (JSResolveUtil.isSelfReference((PsiElement)node)) {
                    return;
                }
                ResolveResult[] results = node.multiResolve(false);
                if ("arguments".equals(node.getText()) && results.length == 1 && results[0].getElement() instanceof ImplicitJSVariableImpl) {
                    JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
                    if (function == null) {
                        return;
                    }
                    Map unusedSymbolsStatus = JSUnusedLocalSymbolsInspection.this.getUnusedDeclarationsMap((PsiElement)function, session, holder);
                    if (unusedSymbolsStatus == null) {
                        return;
                    }
                    for (JSParameter p : function.getParameterVariables()) {
                        unusedSymbolsStatus.put(p, Boolean.FALSE);
                    }
                    return;
                }
                this.registerReferencedFromReferences(results, (PsiReference)node);
            }

            public void visitJSDocTagValue(JSDocTagValue tagValue) {
                for (PsiReference reference : tagValue.getReferences()) {
                    JSElementIndexingData indexingData;
                    JSDocComment docComment;
                    PsiElement resolve;
                    if (!(reference instanceof JSDocReference) || (resolve = reference.resolve()) == null || (docComment = JSStubBasedPsiTreeUtil.findDocComment(resolve)) == null || (indexingData = docComment.getIndexingData()) == null || ContainerUtil.isEmpty((Collection)indexingData.getTypedefs())) continue;
                    this.registerReferencedFromReferences(((JSDocReference)reference).multiResolve(false), reference);
                }
            }

            public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
                ES6ExportDeclaration declaration = node.getDeclaration();
                if (declaration == null || declaration.getFromClause() != null) {
                    return;
                }
                ResolveResult[] results = node.multiResolve(false);
                this.registerReferencedFromReferences(results, (PsiReference)node);
            }

            private void registerReferencedFromReferences(ResolveResult[] results, PsiReference reference) {
                for (ResolveResult r : results) {
                    PsiElement element = r.getElement();
                    this.registerReferencedFromReference(element, reference);
                }
            }

            private void registerReferencedFromReference(PsiElement target, @NotNull PsiReference reference) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection$1", "registerReferencedFromReference"));
                }
                if (target instanceof JSNamedElement && (!(target instanceof JSFunction) || JSUnusedLocalSymbolsInspection.isSupportedFunction((JSFunction)target))) {
                    Map unusedSet;
                    assert (!(target instanceof JSFunctionExpression));
                    JSElement scopeHandler = JSUnusedLocalSymbolsInspection.getScopeNode((JSNamedElement)target);
                    if (scopeHandler != null && (unusedSet = JSUnusedLocalSymbolsInspection.this.getUnusedDeclarationsMap((PsiElement)scopeHandler, session, holder)) != null) {
                        if (!(target instanceof JSFunction && reference instanceof PsiElement && PsiTreeUtil.isAncestor((PsiElement)target, (PsiElement)((PsiElement)reference), (boolean)true))) {
                            unusedSet.put((JSNamedElement)target, Boolean.FALSE);
                        }
                        if (JSResolveUtil.isConstructorFunction(target)) {
                            Map parentUnusedMap;
                            JSElement parentScopeHandler;
                            PsiElement elementParent = target.getParent();
                            JSElement jSElement = parentScopeHandler = elementParent instanceof JSNamedElement ? JSUnusedLocalSymbolsInspection.getScopeNode((JSNamedElement)elementParent) : null;
                            if (parentScopeHandler != null && (parentUnusedMap = JSUnusedLocalSymbolsInspection.this.getUnusedDeclarationsMap((PsiElement)parentScopeHandler, session, holder)) != null) {
                                parentUnusedMap.put((JSNamedElement)elementParent, Boolean.FALSE);
                            }
                        }
                    }
                }
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.visitJSFunctionDeclaration((JSFunction)node);
            }

            public void visitJSNamespaceDeclaration(JSNamespaceDeclaration node) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)node, session, holder);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)node, session, holder);
            }

            public void visitJSClass(JSClass aClass) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)aClass, session, holder);
            }

            private void checkUsagesPrivateField(JSParameter parameter) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)parameter, session, holder);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static boolean isJSAbstractMethod(JSFunction function) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)function);
        boolean js = dialect != null && dialect.isJavaScript();
        JSSourceElement[] body = function.getBody();
        if (js && (body.length == 0 || PsiTreeUtil.findChildOfType((PsiElement)body[0], JSStatement.class) == null)) {
            return true;
        }
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)function);
        return docComment instanceof JSDocComment && ((JSDocComment)docComment).hasAbstractTag();
    }

    private static boolean isSupportedFunction(JSFunction element) {
        return !(element instanceof JSFunctionExpression) && !(element.getContext() instanceof JSProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeclarationHost(PsiElement node, Map<JSNamedElement, Boolean> unusedDeclarationsStatus, ProblemsHolder holder, @NotNull Consumer<JSNamedElement> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "processDeclarationHost"));
        }
        if (node instanceof JSFile && node.getContext() != null) {
            return;
        }
        if (unusedDeclarationsStatus == null || unusedDeclarationsStatus.size() == 0) {
            return;
        }
        try {
            if (node instanceof JSFunction && ((JSFunction)node).getBody().length == 0) {
                return;
            }
            int nonCounted = -2;
            int lastUsedParameterIndex = -2;
            TObjectIntHashMap parameterIndexMap = null;
            ThreeState participatesInHierarchy = ThreeState.UNSURE;
            for (Map.Entry<JSNamedElement, Boolean> e : unusedDeclarationsStatus.entrySet()) {
                PsiElement highlightedElement;
                ASTNode nameIdentifier;
                JSNamedElement p = e.getKey();
                if (!p.isValid() || e.getValue() == Boolean.FALSE) continue;
                JSNamedElementKind namedElementKind = JSNamedElementKind.kind((PsiElement)p, true);
                boolean asinfo = false;
                if (RefUtil.isImplicitUsage((PsiElement)p)) continue;
                if (p instanceof JSParameter) {
                    if (this.myIgnoreUnusedFunctionParameters && node instanceof JSFunction) continue;
                    if (node instanceof JSFunction) {
                        boolean ecma;
                        boolean bl = ecma = node.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                        if (ecma && node instanceof JSFunctionExpression) continue;
                        JSParameter[] params = ((JSFunction)node).getParameterVariables();
                        if (lastUsedParameterIndex == -2) {
                            BitSet unusedSet = new BitSet(params.length);
                            parameterIndexMap = new TObjectIntHashMap();
                            for (int i = 0; i < params.length; ++i) {
                                parameterIndexMap.put((Object)params[i], i);
                            }
                            for (Map.Entry<JSNamedElement, Boolean> entry : unusedDeclarationsStatus.entrySet()) {
                                JSNamedElement param = entry.getKey();
                                if (!(param instanceof JSParameter) || entry.getValue() == Boolean.FALSE) continue;
                                unusedSet.set(parameterIndexMap.get((Object)((JSParameter)param)));
                            }
                            lastUsedParameterIndex = -1;
                            for (int i = params.length - 1; i >= 0; --i) {
                                if (unusedSet.get(i)) continue;
                                lastUsedParameterIndex = i;
                                break;
                            }
                        }
                        if (!(p.getParent() instanceof JSDestructuringProperty) && parameterIndexMap.get((Object)((JSParameter)p)) < lastUsedParameterIndex && node instanceof JSFunctionExpression) continue;
                        JSFunction fun = (JSFunction)node;
                        if (participatesInHierarchy == ThreeState.UNSURE) {
                            JSAttributeList attributeList = fun.getAttributeList();
                            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                                participatesInHierarchy = ThreeState.YES;
                            } else {
                                ThreeState threeState = participatesInHierarchy = JSInheritanceUtil.participatesInHierarchy(fun) ? ThreeState.YES : ThreeState.NO;
                            }
                        }
                        if (participatesInHierarchy == ThreeState.YES) {
                            asinfo = true;
                        }
                        if (JSUnusedLocalSymbolsInspection.isJSAbstractMethod(fun)) {
                            asinfo = true;
                        }
                    }
                    if ((nameIdentifier = p.findNameIdentifier()) == null) continue;
                    highlightedElement = nameIdentifier.getPsi();
                } else {
                    nameIdentifier = p.findNameIdentifier();
                    if (nameIdentifier == null) continue;
                    highlightedElement = nameIdentifier.getPsi();
                }
                String name = p.getName();
                if (name != null && name.startsWith("ignore")) continue;
                String message = JSUnusedLocalSymbolsInspection.unusedMessage(namedElementKind);
                SmartList fixes = new SmartList();
                if (!(asinfo || node instanceof JSFunction && ((JSFunction)node).isSetProperty())) {
                    FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(namedElementKind, name);
                    fix.registerElementRefForFix(highlightedElement, null);
                    fixes.add(fix);
                }
                if (holder.isOnTheFly() && node instanceof JSFunction && p instanceof JSParameter) {
                    JSFixFactory.getInstance().addFixesForFields((JSFunction)node, highlightedElement, name, (List<LocalQuickFix>)fixes);
                }
                LocalQuickFix[] quickFixes = fixes.size() == 0 ? LocalQuickFix.EMPTY_ARRAY : fixes.toArray(new LocalQuickFix[fixes.size()]);
                ProblemHighlightType highlightType = asinfo ? ProblemHighlightType.INFORMATION : ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                holder.registerProblem(highlightedElement, message, highlightType, quickFixes);
                if (asinfo) continue;
                consumer.consume((Object)p);
            }
        }
        finally {
            unusedDeclarationsStatus.clear();
        }
    }

    static String unusedMessage(JSNamedElementKind namedElementKind) {
        return JSBundle.message((String)"js.unused.symbol", (Object[])new Object[]{StringUtil.decapitalize((String)JSBundle.message((String)namedElementKind.humanReadableKey(), (Object[])new Object[0]))});
    }

    private void handleLocalDeclaration(JSNamedElement node, LocalInspectionToolSession session, ProblemsHolder holder) {
        JSElement scopeNode = JSUnusedLocalSymbolsInspection.getScopeNode(node);
        if (scopeNode == null) {
            return;
        }
        Map<JSNamedElement, Boolean> unusedLocalDefsSet = this.getUnusedDeclarationsMap((PsiElement)scopeNode, session, holder);
        if (unusedLocalDefsSet == null) {
            return;
        }
        if (this.isLocallyDefined(node, (PsiElement)scopeNode)) {
            this.addUnusedElementIfNotUsedBefore(node, unusedLocalDefsSet);
        }
    }

    public static boolean isNotGloballyDefined(JSNamedElement node) {
        return JSUnusedLocalSymbolsInspection.isNonDefinitionExpression(node) || JSUnusedLocalSymbolsInspection.checkIfLocallyDefined(node, (PsiElement)JSUnusedLocalSymbolsInspection.getScopeNode(node));
    }

    protected boolean isLocallyDefined(JSNamedElement node, PsiElement scopeNode) {
        return JSUnusedLocalSymbolsInspection.checkIfLocallyDefined(node, scopeNode) && !JSUnusedLocalSymbolsInspection.isNonDefinitionExpression(node);
    }

    private static boolean isNonDefinitionExpression(@NotNull JSNamedElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "isNonDefinitionExpression"));
        }
        return node instanceof JSExpression && !(node instanceof JSDefinitionExpression);
    }

    protected static boolean checkIfLocallyDefined(JSNamedElement node, PsiElement scopeNode) {
        if (node instanceof JSFunction && !JSUnusedLocalSymbolsInspection.isSupportedFunction((JSFunction)node)) {
            return false;
        }
        return JSUtils.isLocallyDefined(node, scopeNode);
    }

    protected void addUnusedElementIfNotUsedBefore(JSNamedElement node, Map<JSNamedElement, Boolean> unusedLocalDefsSet) {
        unusedLocalDefsSet.putIfAbsent(node, Boolean.TRUE);
    }

    private static JSElement getScopeNode(JSNamedElement node) {
        if (node instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)node).getStub() != null) {
            return null;
        }
        return JSPsiImplUtils.getScopeNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<JSNamedElement, Boolean> getUnusedDeclarationsMap(PsiElement parent, LocalInspectionToolSession session, ProblemsHolder holder) {
        Map map = (Map)session.getUserData(this.getUnsedScopeMapKey());
        LocalInspectionToolSession localInspectionToolSession = session;
        synchronized (localInspectionToolSession) {
            Map unusedFileMap = (Map)ContainerUtil.getOrCreate((Map)map, (Object)holder, () -> new THashMap());
            return (Map)ContainerUtil.getOrCreate((Map)unusedFileMap, (Object)parent, () -> ContainerUtil.newConcurrentMap());
        }
    }

    protected Key<Map<ProblemsHolder, Map<PsiElement, Map<JSNamedElement, Boolean>>>> getUnsedScopeMapKey() {
        return ourUnusedScopeMapKey;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "inspectionStarted"));
        }
        super.inspectionStarted(session, isOnTheFly);
        session.putUserDataIfAbsent(this.getUnsedScopeMapKey(), (Object)new THashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        Set entries;
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "inspectionFinished"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "inspectionFinished"));
        }
        super.inspectionFinished(session, problemsHolder);
        Map map = (Map)session.getUserData(this.getUnsedScopeMapKey());
        if (map == null) {
            return;
        }
        LocalInspectionToolSession localInspectionToolSession = session;
        synchronized (localInspectionToolSession) {
            Map currentFileMap = (Map)map.get(problemsHolder);
            if (currentFileMap == null) {
                return;
            }
            entries = currentFileMap.entrySet();
        }
        JSSharedUsageInformation sharedInfo = JSSharedUsageInformation.get(session.getFile());
        Consumer consumer = element -> sharedInfo.registerDeclaration((PsiNamedElement)element);
        for (Map.Entry e : entries) {
            ((Map)e.getValue()).forEach((element, unused) -> {
                if (!unused.booleanValue()) {
                    sharedInfo.registerLocallyReferencedDeclaration((PsiNamedElement)element);
                }
            });
            this.processDeclarationHost((PsiElement)e.getKey(), (Map)e.getValue(), problemsHolder, (Consumer<JSNamedElement>)consumer);
        }
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.ignore.unused.function.parameters", (Object[])new Object[0]), "myIgnoreUnusedFunctionParameters");
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.ignore.unused.catch.parameters", (Object[])new Object[0]), "myIgnoreUnusedCatchParameters");
        return optionsPanel;
    }
}

