/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.ES6ModulesSuggester;
import com.intellij.lang.javascript.modules.JSBaseModulesDependenciesElementVisitor;
import com.intellij.lang.javascript.modules.JSSimpleModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXNamespaceValidationInspection
extends JSInspection
implements JSXNamespaceProvider {
    public static final String SHORT_NAME = JSXNamespaceValidationInspection.calcShortNameFromClass(JSXNamespaceValidationInspection.class);
    private static final Key<Boolean> VALIDATED_FLAG = Key.create((String)"JSX.Inspection.Namespace.Validation");
    public boolean importPopup = false;
    public String requiredNamespace = "React";

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (!DialectDetector.isJSX((PsiElement)node)) {
                    return;
                }
                if (!(node instanceof JSXmlLiteralExpressionImpl)) {
                    return;
                }
                if (Boolean.TRUE.equals(session.getUserData(VALIDATED_FLAG))) {
                    return;
                }
                String namespace = JSXNamespaceValidationInspection.this.getNamespace((PsiElement)node);
                if (StringUtil.isEmpty((String)namespace)) {
                    return;
                }
                JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)node, JSExecutionScope.class);
                if (scope == null) {
                    return;
                }
                final Ref hasElement = Ref.create((Object)Boolean.FALSE);
                JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, new JSResolveProcessorBase(namespace){

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$1$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$1$1", "execute"));
                        }
                        hasElement.set((Object)Boolean.TRUE);
                        return false;
                    }
                }, true);
                if (((Boolean)hasElement.get()).booleanValue()) {
                    return;
                }
                JSXNamespaceValidationInspection.this.registerProblem(holder, session, node, namespace);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @Override
    @Nullable
    public String getNamespace(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "getNamespace"));
        }
        if (DialectDetector.isTypeScript(context)) {
            TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(context.getContainingFile());
            if (config2 == null) {
                return this.requiredNamespace;
            }
            String namespace = config2.getRawCompilerOption("reactNamespace");
            if (!StringUtil.isEmpty((String)namespace)) {
                return StringUtil.unquoteString((String)namespace);
            }
        }
        return this.requiredNamespace;
    }

    private void registerProblem(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, @NotNull JSLiteralExpression context, @NotNull String namespace) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "registerProblem"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "registerProblem"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "registerProblem"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "registerProblem"));
        }
        session.putUserData(VALIDATED_FLAG, (Object)Boolean.TRUE);
        PsiReference reference = context.getReference();
        if (reference != null) {
            List<LocalQuickFix> fixes = this.getFixes(holder, session, context, namespace);
            holder.registerProblemForReference(reference, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, JSBundle.message((String)"jsx.missing.namespace.inspection.text", (Object[])new Object[]{namespace}), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private List<LocalQuickFix> getFixes(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, @NotNull JSLiteralExpression context, final @NotNull String namespace) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "getFixes"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "getFixes"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "getFixes"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection", "getFixes"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        if (DialectDetector.isTypeScript((PsiElement)context)) {
            ASTNode nameNode = context.getNode().findChildByType(JSTokenTypes.XML_TAG_NAME);
            if (nameNode != null) {
                ES6ImportAction.ImportElementFilter filter = new ES6ImportAction.ImportElementFilter(){

                    @Override
                    @NotNull
                    public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result) {
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$2", "filterByContext"));
                        }
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$2", "filterByContext"));
                        }
                        List<JSElement> list = result;
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$2", "filterByContext"));
                        }
                        return list;
                    }

                    @Override
                    public boolean isValidContext(@NotNull PsiElement context) {
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$2", "isValidContext"));
                        }
                        return true;
                    }
                };
                result.add(new TypeScriptAddImportStatementFix(namespace, nameNode.getPsi(), this.importPopup, filter){

                    @Override
                    @Nls
                    @NotNull
                    public String getText() {
                        String string = JSBundle.message((String)"tsx.missing.name.quick.fix.name", (Object[])new Object[]{"'" + namespace + "'"});
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSXNamespaceValidationInspection$3", "getText"));
                        }
                        return string;
                    }
                });
            }
        } else {
            JSSimpleModuleReferenceInfo info = new JSSimpleModuleReferenceInfo(namespace, this.importPopup);
            Set<VirtualFile> files = JSBaseModulesDependenciesElementVisitor.cacheAndGetPredefinedLibraries(context.getProject(), session);
            ES6ModulesSuggester suggester = new ES6ModulesSuggester(session, files, info, (PsiElement)context);
            MultiMap<PsiElement, LocalQuickFix> fixes = suggester.findFixes(ResolveResult.EMPTY_ARRAY);
            result.addAll(fixes.values());
        }
        return result;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        final JBTextField namespace = new JBTextField(this.requiredNamespace);
        namespace.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                JSXNamespaceValidationInspection.this.requiredNamespace = namespace.getText();
            }
        });
        CheckBox importPopup = new CheckBox("", (InspectionProfileEntry)this, "importPopup");
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addLabeledComponent("Import popup:", (JComponent)importPopup);
        builder.addLabeledComponent("Namespace:", (JComponent)namespace);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)builder.getPanel(), "North");
        return wrapper;
    }
}

