/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json.adapters;

import com.intellij.lang.javascript.json.adapters.JSJsonArrayAdapter;
import com.intellij.lang.javascript.json.adapters.JSJsonGenericValueAdapter;
import com.intellij.lang.javascript.json.adapters.JSJsonObjectAdapter;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJsonPropertyAdapter
implements JsonPropertyAdapter {
    @NotNull
    private final JSProperty myProperty;

    public JSJsonPropertyAdapter(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter", "<init>"));
        }
        this.myProperty = property;
    }

    @Nullable
    public String getName() {
        return this.myProperty.getName();
    }

    @Nullable
    public JsonValueAdapter getValue() {
        return this.myProperty.getValue() == null ? null : JSJsonPropertyAdapter.createValueAdapterByType(this.myProperty.getValue());
    }

    @NotNull
    public PsiElement getDelegate() {
        JSProperty jSProperty = this.myProperty;
        if (jSProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter", "getDelegate"));
        }
        return jSProperty;
    }

    @Nullable
    public JsonObjectValueAdapter getParentObject() {
        return this.myProperty.getParent() instanceof JSObjectLiteralExpression ? new JSJsonObjectAdapter((JSObjectLiteralExpression)this.myProperty.getParent()) : null;
    }

    @Nullable
    public JsonArrayValueAdapter getParentArray() {
        return this.myProperty.getParent() instanceof JSArrayLiteralExpression ? new JSJsonArrayAdapter((JSArrayLiteralExpression)this.myProperty.getParent()) : null;
    }

    @NotNull
    public static JsonValueAdapter createValueAdapterByType(@NotNull JSExpression value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter", "createValueAdapterByType"));
        }
        if (value instanceof JSObjectLiteralExpression) {
            JSJsonObjectAdapter jSJsonObjectAdapter = new JSJsonObjectAdapter((JSObjectLiteralExpression)value);
            if (jSJsonObjectAdapter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter", "createValueAdapterByType"));
            }
            return jSJsonObjectAdapter;
        }
        if (value instanceof JSArrayLiteralExpression) {
            JSJsonArrayAdapter jSJsonArrayAdapter = new JSJsonArrayAdapter((JSArrayLiteralExpression)value);
            if (jSJsonArrayAdapter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter", "createValueAdapterByType"));
            }
            return jSJsonArrayAdapter;
        }
        JSJsonGenericValueAdapter jSJsonGenericValueAdapter = new JSJsonGenericValueAdapter(value);
        if (jSJsonGenericValueAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/adapters/JSJsonPropertyAdapter", "createValueAdapterByType"));
        }
        return jSJsonGenericValueAdapter;
    }
}

