/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessDialog;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryWritingAccessProvider
extends WritingAccessProvider {
    private static final Key<Boolean> JS_ALL_WRITE_ACCESS_ALLOWED = Key.create((String)"JS_ALL_WRITE_ACCESS_ALLOWED");
    private static final Key<Boolean> JS_WRITE_ACCESS_ALLOWED = Key.create((String)"JS_WRITE_ACCESS_ALLOWED");
    private final Project myProject;

    public JSLibraryWritingAccessProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        if (JS_ALL_WRITE_ACCESS_ALLOWED.get((UserDataHolder)this.myProject) == Boolean.TRUE) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider", "requestWriting"));
            }
            return list;
        }
        List deniedFiles = null;
        for (VirtualFile file : files) {
            if (JS_WRITE_ACCESS_ALLOWED.get((UserDataHolder)file) == Boolean.TRUE || !(file.getFileSystem() instanceof LocalFileSystem) || this.isWriteAccessAllowedByDefault(file)) continue;
            if (deniedFiles == null) {
                deniedFiles = new SmartList();
            }
            deniedFiles.add(file);
        }
        if (deniedFiles == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider", "requestWriting"));
            }
            return list;
        }
        NonProjectFileWritingAccessProvider.UnlockOption unlockOption = this.askToUnlock(deniedFiles);
        if (unlockOption == null) {
            List list = deniedFiles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider", "requestWriting"));
            }
            return list;
        }
        if (unlockOption == NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK) {
            for (VirtualFile deniedFile : deniedFiles) {
                JS_WRITE_ACCESS_ALLOWED.set((UserDataHolder)deniedFile, (Object)Boolean.TRUE);
            }
        } else {
            JS_ALL_WRITE_ACCESS_ALLOWED.set((UserDataHolder)this.myProject, (Object)Boolean.TRUE);
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider", "requestWriting"));
        }
        return list;
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider", "isPotentiallyWritable"));
        }
        return true;
    }

    private boolean isWriteAccessAllowedByDefault(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider", "isWriteAccessAllowedByDefault"));
        }
        FileType fileType = file.getFileType();
        if (!DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType)) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (fileIndex.isInLibrarySource(file) || fileIndex.isInLibraryClasses(file)) {
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
            return !libraryManager.isLibraryFile(file);
        }
        return true;
    }

    @Nullable
    private NonProjectFileWritingAccessProvider.UnlockOption askToUnlock(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider", "askToUnlock"));
        }
        NonProjectFileWritingAccessDialog dialog = new NonProjectFileWritingAccessDialog(this.myProject, files, "JavaScript Library Files");
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog.getUnlockOption();
    }

    private static class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        private final JSLibraryWritingAccessProvider myProvider;

        public AccessExtension(@NotNull JSLibraryWritingAccessProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider$AccessExtension", "<init>"));
            }
            this.myProvider = provider;
        }

        public boolean isWritable(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryWritingAccessProvider$AccessExtension", "isWritable"));
            }
            return !this.myProvider.isWriteAccessAllowedByDefault(file);
        }
    }
}

