/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleConfigurationView {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myPackageField;

    public NodeModuleConfigurationView(@NotNull Project project, @NotNull String packageName, @NotNull String titlePackageName, @Nullable NodeJsInterpreterRef ref) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        if (titlePackageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titlePackageName", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        if (ref != null) {
            this.myNodeInterpreterField.setInterpreterRef(ref);
        }
        this.myPackageField = new NodePackageField(project, packageName, () -> this.myNodeInterpreterField.getInterpreter());
    }

    public static Pair<TextFieldWithHistoryWithBrowseButton, Getter<Boolean>> createRemotePackageField(final Project project, String name, String titlePackage, final @NotNull Getter<NodeJsInterpreter> nodePathProvider) {
        if (nodePathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "createRemotePackageField"));
        }
        final TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        final Getter browsingAvailable = () -> {
            if (nodePathProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "lambda$createRemotePackageField$1"));
            }
            String id = ((NodeJsInterpreter)nodePathProvider.get()).getPresentableName();
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt("Choose Remote Package");
            if (manager != null) {
                RemoteSdkAdditionalData data;
                try {
                    data = manager.getRemoteSdkAdditionalData(project, id);
                }
                catch (Exception e) {
                    return false;
                }
                CredentialsType type = data.getRemoteConnectionType();
                if (type instanceof CredentialsTypeEx && !((CredentialsTypeEx)type).isBrowsingAvailable()) {
                    return false;
                }
                return true;
            }
            return false;
        };
        textFieldWithHistoryWithBrowseButton.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String id = ((NodeJsInterpreter)nodePathProvider.get()).getPresentableName();
                NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt("Choose Remote Package");
                if (manager != null) {
                    try {
                        if (!Boolean.TRUE.equals(browsingAvailable.get())) {
                            return;
                        }
                        String path = manager.chooseRemoteFile(project, id, true);
                        if (path != null) {
                            textFieldWithHistoryWithBrowseButton.setText(path);
                        }
                    }
                    catch (Exception e1) {
                        NodeUIUtil.balloonInfo(project, e1.getMessage(), textFieldWithHistoryWithBrowseButton.getLocationOnScreen(), MessageType.ERROR);
                    }
                }
            }
        });
        return Pair.create((Object)textFieldWithHistoryWithBrowseButton, (Object)browsingAvailable);
    }

    public NodeJsInterpreterField getNodeInterpreterField() {
        return this.myNodeInterpreterField;
    }

    public NodePackageField getPackageField() {
        return this.myPackageField;
    }

    public void setPreferredWidthToComponents() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
    }
}

