/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintSuppressionUtil {
    private static final Pattern LINE_SUPPRESSION_PATTERN = Pattern.compile("//\\s*eslint-disable-next-line\\s*(\\S*)\\s*");
    private static final Pattern FILE_SUPPRESSION_PATTERN = Pattern.compile("/\\*\\s*eslint-disable\\s*(\\S+)\\s*\\*/");

    private EslintSuppressionUtil() {
    }

    public static SuppressQuickFix[] getBatchSuppressActions(@Nullable HighlightDisplayKey displayKey, @Nullable PsiElement element) {
        if (displayKey == null) {
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        Class<? extends JSSuppressionHolder> holderClass = JSInspectionSuppressor.getHolderClass(element);
        return new SuppressQuickFix[]{new SuppressForFileByCommentFix(displayKey, holderClass), new SuppressForLineByCommentFix(displayKey, holderClass)};
    }

    @NotNull
    public static List<IntentionAction> getSuppressionsForError(@NotNull JSLinterErrorBase error, boolean isOnTheFly) {
        String code;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "getSuppressionsForError"));
        }
        JSLinterError linterError = error instanceof JSLinterError ? (JSLinterError)error : null;
        ArrayList list = ContainerUtil.newArrayList();
        String string = code = linterError != null ? linterError.getCode() : null;
        if (linterError == null || StringUtil.isEmpty((String)code)) {
            ArrayList arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "getSuppressionsForError"));
            }
            return arrayList;
        }
        if (isOnTheFly) {
            list.add(new SuppressForLineIntentionAction(code, linterError.getLine()));
        }
        list.add(new SuppressForFileIntentionAction(code, linterError.getLine()));
        ArrayList arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "getSuppressionsForError"));
        }
        return arrayList;
    }

    private static void insertFileSuppressionComment(@NotNull Project project, @NotNull PsiElement rootElement, @Nullable String ruleCode) {
        Matcher matcher;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "insertFileSuppressionComment"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "insertFileSuppressionComment"));
        }
        String existingSuppressions = null;
        PsiComment suppressionComment = EslintSuppressionUtil.findFileSuppressionComment(rootElement);
        if (suppressionComment != null && (matcher = FILE_SUPPRESSION_PATTERN.matcher(suppressionComment.getText())).matches()) {
            existingSuppressions = matcher.group(1);
        }
        String rules = EslintSuppressionUtil.getRulesText(existingSuppressions, ruleCode);
        String commentText = String.format("/* eslint-disable%s */\n\n", !StringUtil.isEmpty((String)rules) ? ' ' + rules : "");
        ASTNode newComment = JSChangeUtil.createJSTreeFromText(project, commentText, DialectDetector.languageDialectOfElement(rootElement));
        if (newComment == null) {
            return;
        }
        if (suppressionComment != null) {
            suppressionComment.replace(newComment.getPsi());
        } else {
            rootElement.addBefore(newComment.getPsi(), rootElement.getFirstChild());
            boolean isScriptBlockInHtml = rootElement instanceof JSEmbeddedContent;
            if (isScriptBlockInHtml) {
                rootElement.addBefore(JSChangeUtil.createJSTreeFromText(project, "\n").getPsi(), rootElement.getFirstChild());
            }
        }
    }

    private static void insertLineSuppressionComment(@NotNull Project project, @NotNull Document document, @NotNull PsiElement rootElement, int lineNumber, @Nullable String ruleCode) {
        Matcher matcher;
        int previousLineEnd;
        int previousLineStart;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "insertLineSuppressionComment"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "insertLineSuppressionComment"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "insertLineSuppressionComment"));
        }
        String existingSuppressions = null;
        PsiElement existingComment = null;
        if (lineNumber > 0 && (existingComment = EslintSuppressionUtil.findLineCommentInRange(rootElement, previousLineStart = document.getLineStartOffset(lineNumber - 1), previousLineEnd = document.getLineEndOffset(lineNumber - 1))) != null && (matcher = LINE_SUPPRESSION_PATTERN.matcher(existingComment.getText())).matches()) {
            existingSuppressions = matcher.group(1);
        }
        String rules = EslintSuppressionUtil.getRulesText(existingSuppressions, ruleCode);
        String comment = String.format("//%seslint-disable-next-line%s\n", JSCodeStyleSettings.getLineCommentPrefix(rootElement), !StringUtil.isEmpty((String)rules) ? ' ' + rules : "");
        if (existingComment != null) {
            ASTNode newComment = JSChangeUtil.createJSTreeFromText(project, comment, DialectDetector.languageDialectOfElement(rootElement));
            if (newComment == null) {
                return;
            }
            existingComment.replace(newComment.getPsi());
        } else {
            int insertionOffset = document.getLineStartOffset(lineNumber);
            int rootElementStartOffset = rootElement.getNode().getStartOffset();
            if (rootElementStartOffset > insertionOffset) {
                insertionOffset = rootElementStartOffset;
                comment = "\n" + comment.trim();
            }
            document.insertString(insertionOffset, (CharSequence)comment);
        }
    }

    @Nullable
    private static PsiElement findLineCommentInRange(@NotNull PsiElement file, int lineStart, int lineEnd) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "findLineCommentInRange"));
        }
        return EslintSuppressionUtil.findIntersectingLeaf(file, lineStart, lineEnd, (Condition<PsiElement>)((Condition)element -> {
            PsiComment comment = element instanceof PsiComment ? (PsiComment)element : null;
            return comment != null && comment.getTokenType() == JSTokenTypes.END_OF_LINE_COMMENT && comment.getText().contains("eslint-disable-next-line");
        }));
    }

    @Nullable
    private static PsiElement findIntersectingLeaf(@NotNull PsiElement rootElement, int start, int end, @NotNull Condition<PsiElement> condition) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "findIntersectingLeaf"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "findIntersectingLeaf"));
        }
        PsiElement element = rootElement.getContainingFile().getViewProvider().findElementAt(start);
        while (element != null) {
            if (element.getTextRange().intersects(start, end) && condition.value((Object)element)) {
                return element;
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return null;
    }

    @Nullable
    private static PsiElement getRootJsElement(PsiFile file, int lineNumber) {
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        PsiElement jsElement = EslintSuppressionUtil.findIntersectingLeaf((PsiElement)file, lineStartOffset, lineEndOffset, (Condition<PsiElement>)((Condition)leaf -> EslintSuppressionUtil.getRootJSElement(leaf) != null));
        return EslintSuppressionUtil.getRootJSElement(jsElement);
    }

    @Nullable
    private static PsiComment findFileSuppressionComment(@NotNull PsiElement rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "findFileSuppressionComment"));
        }
        Ref commentRef = new Ref();
        PsiTreeUtil.processElements((PsiElement)rootElement, element -> {
            if (rootElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "lambda$findFileSuppressionComment$2"));
            }
            if (element != rootElement && !(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace)) {
                return false;
            }
            if (element instanceof PsiComment && element.getNode().getElementType() == JSTokenTypes.C_STYLE_COMMENT && element.getText().contains("eslint-disable")) {
                commentRef.set((Object)((PsiComment)element));
                return false;
            }
            return true;
        });
        return (PsiComment)commentRef.get();
    }

    @NotNull
    private static String getRulesText(@Nullable String existingSuppressions, @Nullable String ruleCode) {
        if (StringUtil.isEmpty((String)ruleCode)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "getRulesText"));
            }
            return "";
        }
        if (!StringUtil.isEmpty((String)existingSuppressions)) {
            String string = existingSuppressions + "," + ruleCode;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "getRulesText"));
            }
            return string;
        }
        String string = ruleCode;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil", "getRulesText"));
        }
        return string;
    }

    @Nullable
    @Contract(value="null -> null")
    private static JSElement getRootJSElement(@Nullable PsiElement element) {
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSFile.class, JSEmbeddedContent.class});
    }

    private static String getSuppressForLineDescription(@Nullable String code) {
        return String.format("Suppress %s for current line", EslintSuppressionUtil.getRuleDescription(code));
    }

    private static String getSuppressForFileDescription(String ruleCode) {
        return String.format("Suppress %s for current file", EslintSuppressionUtil.getRuleDescription(ruleCode));
    }

    private static String getRuleDescription(@Nullable String code) {
        return StringUtil.isEmpty((String)code) ? "all ESLint rules" : String.format("rule '%s'", code);
    }

    private static class SuppressForFileIntentionAction
    extends BaseIntentionAction {
        @NotNull
        private final String myRuleCode;
        private final int myLine;

        public SuppressForFileIntentionAction(@NotNull String code, int line) {
            if (code == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileIntentionAction", "<init>"));
            }
            this.myRuleCode = code;
            this.myLine = line;
        }

        @NotNull
        public String getText() {
            String string = EslintSuppressionUtil.getSuppressForFileDescription(this.myRuleCode);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileIntentionAction", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Suppress for current file" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileIntentionAction", "getFamilyName"));
            }
            return "Suppress for current file";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileIntentionAction", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileIntentionAction", "invoke"));
            }
            PsiElement rootElement = EslintSuppressionUtil.getRootJsElement(file, this.myLine);
            if (rootElement == null) {
                return;
            }
            EslintSuppressionUtil.insertFileSuppressionComment(project, rootElement, this.myRuleCode);
        }
    }

    private static class SuppressForLineIntentionAction
    extends BaseIntentionAction {
        @NotNull
        private final String myRuleCode;
        private int myLineNumber;

        public SuppressForLineIntentionAction(@NotNull String myRuleCode, int lineNumber) {
            if (myRuleCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myRuleCode", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineIntentionAction", "<init>"));
            }
            this.myRuleCode = myRuleCode;
            this.myLineNumber = lineNumber;
        }

        @NotNull
        public String getText() {
            String string = EslintSuppressionUtil.getSuppressForLineDescription(this.myRuleCode);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineIntentionAction", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Suppress for current line" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineIntentionAction", "getFamilyName"));
            }
            return "Suppress for current line";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineIntentionAction", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineIntentionAction", "invoke"));
            }
            Document document = ((Editor)ObjectUtils.assertNotNull((Object)editor)).getDocument();
            PsiElement rootJsElement = EslintSuppressionUtil.getRootJsElement(file, this.myLineNumber);
            if (rootJsElement == null) {
                return;
            }
            EslintSuppressionUtil.insertLineSuppressionComment(project, document, rootJsElement, this.myLineNumber, this.myRuleCode);
        }
    }

    private static class SuppressForLineByCommentFix
    extends SuppressByCommentFix {
        public SuppressForLineByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends PsiElement> suppressionHolderClass) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineByCommentFix", "<init>"));
            }
            if (suppressionHolderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressionHolderClass", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineByCommentFix", "<init>"));
            }
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress all rules for current line" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineByCommentFix", "getText"));
            }
            return "Suppress all rules for current line";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineByCommentFix", "createSuppression"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineByCommentFix", "createSuppression"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForLineByCommentFix", "createSuppression"));
            }
            Document document = JSLinterUtil.getDocumentForElement(element);
            if (document == null) {
                return;
            }
            EslintSuppressionUtil.insertLineSuppressionComment(project, document, element, document.getLineNumber(element.getTextOffset()), null);
        }
    }

    private static class SuppressForFileByCommentFix
    extends SuppressByCommentFix {
        public SuppressForFileByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends PsiElement> suppressionHolderClass) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileByCommentFix", "<init>"));
            }
            if (suppressionHolderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressionHolderClass", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileByCommentFix", "<init>"));
            }
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress all rules for file" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileByCommentFix", "getText"));
            }
            return "Suppress all rules for file";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileByCommentFix", "createSuppression"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileByCommentFix", "createSuppression"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/linter/eslint/EslintSuppressionUtil$SuppressForFileByCommentFix", "createSuppression"));
            }
            JSElement rootElement = EslintSuppressionUtil.getRootJSElement(element);
            if (rootElement != null) {
                EslintSuppressionUtil.insertFileSuppressionComment(project, (PsiElement)rootElement, null);
            }
        }
    }
}

