/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigHelper;
import com.intellij.lang.javascript.linter.jscs.config.JscsExcludeFileInConfigFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JscsCreateConfigAndExcludeFix
implements HighPriorityAction,
IntentionAction {
    @NotNull
    private final String myFileName;
    @NotNull
    private final String myRelativePath;

    public JscsCreateConfigAndExcludeFix(@NotNull String name, @NotNull String path) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/jscs/config/JscsCreateConfigAndExcludeFix", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/jscs/config/JscsCreateConfigAndExcludeFix", "<init>"));
        }
        this.myFileName = name;
        this.myRelativePath = path;
    }

    @NotNull
    public String getText() {
        String string = "Create config.jscs.json and exclude " + this.myFileName + " from JSCS analysis there.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/config/JscsCreateConfigAndExcludeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Create config.jscs.json and exclude file(s) from JSCS analysis there." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/config/JscsCreateConfigAndExcludeFix", "getFamilyName"));
        }
        return "Create config.jscs.json and exclude file(s) from JSCS analysis there.";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsCreateConfigAndExcludeFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsCreateConfigAndExcludeFix", "invoke"));
        }
        VirtualFile config2 = JscsConfigHelper.createConfigBasedOnPreset(project);
        if (config2 != null) {
            new JscsExcludeFileInConfigFix(config2, this.myFileName, this.myRelativePath).invoke(project, editor, file);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

