/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsExcludeFileInConfigFix
implements HighPriorityAction,
IntentionAction {
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final String myFileName;
    @NotNull
    private final String myRelativePath;

    public JscsExcludeFileInConfigFix(@NotNull VirtualFile configFile, @NotNull String fileName, @NotNull String relativePath) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "<init>"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "<init>"));
        }
        this.myConfigFile = configFile;
        this.myFileName = fileName;
        this.myRelativePath = relativePath;
    }

    @NotNull
    public String getText() {
        String string = "Exclude " + this.myFileName + " from JSCS analysis in " + this.myConfigFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Exclude file(s) from analysis in config file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "getFamilyName"));
        }
        return "Exclude file(s) from analysis in config file";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile jsPsiFile) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "invoke"));
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.myConfigFile);
        if (document != null) {
            JsonElementGenerator generator = new JsonElementGenerator(project);
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                Collection properties = PsiTreeUtil.findChildrenOfType((PsiElement)psiFile, JsonProperty.class);
                for (JsonProperty property : properties) {
                    if (!JscsOption.excludeFiles.name().equals(property.getName())) continue;
                    JsonValue value = property.getValue();
                    if (value != null) {
                        this.updateExistingProperty(project, generator, value, psiFile, jsPsiFile);
                    }
                    return;
                }
                this.createNewProperty(project, generator, psiFile, jsPsiFile);
            }
        }
    }

    private void updateExistingProperty(Project project, JsonElementGenerator generator, JsonValue value, PsiFile psiFile, PsiFile jsPsiFile) {
        PsiElement added;
        JsonArray array = (JsonArray)ObjectUtils.tryCast((Object)value, JsonArray.class);
        if (array == null) {
            OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{new OpenFileDescriptor(project, this.myConfigFile, value.getTextOffset())});
            return;
        }
        JsonStringLiteral literal = generator.createStringLiteral(this.myRelativePath);
        List list = array.getValueList();
        if (list.isEmpty()) {
            added = array.addAfter((PsiElement)literal, null);
        } else {
            JsonValue anchor = (JsonValue)list.get(list.size() - 1);
            PsiElement comma = array.addAfter(generator.createComma(), (PsiElement)anchor);
            added = array.addAfter((PsiElement)literal, comma);
        }
        this.reformatAndNavigate(project, added, psiFile, jsPsiFile);
    }

    private void createNewProperty(Project project, JsonElementGenerator generator, PsiFile psiFile, PsiFile jsPsiFile) {
        PsiElement obj = psiFile.getFirstChild();
        JsonObject jsonObject = (JsonObject)ObjectUtils.tryCast((Object)obj, JsonObject.class);
        if (jsonObject == null) {
            return;
        }
        String propertyText = "[\"" + this.myRelativePath + "\"]";
        JsonProperty createdProperty = generator.createProperty(JscsOption.excludeFiles.name(), propertyText);
        List list = jsonObject.getPropertyList();
        PsiElement added = null;
        if (list.isEmpty()) {
            added = jsonObject.replace((PsiElement)generator.createObject("\"" + JscsOption.excludeFiles.name() + "\": " + propertyText));
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
        } else {
            JsonProperty anchor = (JsonProperty)list.get(list.size() - 1);
            PsiElement comma = jsonObject.addAfter(generator.createComma(), (PsiElement)anchor);
            added = jsonObject.addAfter((PsiElement)createdProperty, comma);
        }
        this.reformatAndNavigate(project, added, psiFile, jsPsiFile);
    }

    private void reformatAndNavigate(@NotNull Project project, @Nullable PsiElement created, @NotNull PsiFile config2, @NotNull PsiFile jsPsiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "reformatAndNavigate"));
        }
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "reformatAndNavigate"));
        }
        if (jsPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsPsiFile", "com/intellij/lang/javascript/linter/jscs/config/JscsExcludeFileInConfigFix", "reformatAndNavigate"));
        }
        if (created == null) {
            OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{new OpenFileDescriptor(project, this.myConfigFile)});
            return;
        }
        JsonProperty property = JSLinterConfigFileUtil.getProperty(created);
        int offset = created.getTextOffset();
        if (property != null) {
            offset = property.getTextOffset();
            JsonValue value = property.getValue();
            if (value != null) {
                offset = value.getTextOffset();
            }
        } else {
            Integer offsetObj = (Integer)ObjectUtils.doIfCast((Object)config2.getFirstChild(), JsonObject.class, obj -> {
                List list = obj.getPropertyList();
                for (JsonProperty jsonProperty : list) {
                    if (!JscsOption.excludeFiles.name().equals(StringUtil.stripQuotesAroundValue((String)jsonProperty.getName()))) continue;
                    return jsonProperty.getValue() == null ? null : Integer.valueOf(jsonProperty.getValue().getTextOffset());
                }
                return null;
            });
            offset = offsetObj == null ? offset : offsetObj;
        }
        OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{new OpenFileDescriptor(project, this.myConfigFile, offset)});
        DaemonCodeAnalyzer.getInstance((Project)project).restart(jsPsiFile);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

