/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.ImportES6ModuleFix;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeJsModulesSuggesterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ES6ModulesSuggester
extends NodeJsModulesSuggesterBase {
    public ES6ModulesSuggester(@NotNull LocalInspectionToolSession session, @NotNull Set<VirtualFile> predefinedFiles, @NotNull ModuleReferenceInfo info, @NotNull PsiElement node) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "<init>"));
        }
        if (predefinedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFiles", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "<init>"));
        }
        super(session, predefinedFiles, info, node);
    }

    @Override
    @NotNull
    public MultiMap<PsiElement, LocalQuickFix> findFixes(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "findFixes"));
        }
        List descriptors = this.find(resolveResults, false);
        if (descriptors.isEmpty()) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "findFixes"));
            }
            return multiMap;
        }
        descriptors = ContainerUtil.filter(descriptors, descriptor2 -> {
            String fromPath = descriptor2.getFromPath();
            int idx = fromPath.indexOf("node_modules");
            return idx < 0 || fromPath.indexOf("test", idx) <= 0 && fromPath.indexOf("examples", idx) <= 0;
        });
        String quoteString = JSCodeStyleSettings.getQuote(this.myNode);
        ArrayList<ImportES6ModuleFix> list = new ArrayList<ImportES6ModuleFix>();
        MultiMap result = MultiMap.createLinked();
        int size = descriptors.size();
        for (ModuleFixCreator.FixDescriptor descriptor3 : descriptors) {
            boolean hint = size == 1 && this.myModuleReferenceInfo.needHint();
            list.add(new ImportES6ModuleFix(this.myNode, descriptor3, quoteString, hint));
        }
        result.putValues((Object)this.myNode, list);
        PsiElement parent = this.myModuleReferenceInfo.getParentRef();
        if (parent != null) {
            Project project = this.myNode.getProject();
            ArrayList<ImportES6ModuleFix> secondWordList = new ArrayList<ImportES6ModuleFix>(list);
            for (ModuleFixCreator.FixDescriptor descriptor4 : descriptors) {
                ModuleFixCreator.FixDescriptor fixDescriptor = new ModuleFixCreator.FixDescriptor(descriptor4).withTail((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(parent), new String[]{this.myModuleReferenceInfo.getParentName()});
                secondWordList.add(new ImportES6ModuleFix(parent, fixDescriptor, quoteString, false));
            }
            result.putValues((Object)parent, secondWordList);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "findFixes"));
        }
        return multiMap;
    }
}

