/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionCustomASTComparator
implements TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> {
    private static final TokenSet GENERATOR = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.MULT});

    @NotNull
    public ThreeState fun(@NotNull ASTNode functionNode, @NotNull LighterASTNode newFunctionNode, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure) {
        if (functionNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionNode", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "fun"));
        }
        if (newFunctionNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFunctionNode", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "fun"));
        }
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "fun"));
        }
        if (JSFunctionCustomASTComparator.areFunctions(functionNode, newFunctionNode)) {
            LighterASTNode newGeneratorNode;
            Ref newChildrenRef = Ref.create();
            int newChildrenCount = structure.getChildren((Object)newFunctionNode, newChildrenRef);
            LighterASTNode[] newChildren = (LighterASTNode[])newChildrenRef.get();
            ASTNode generatorNode = JSFunctionCustomASTComparator.getChildNode(functionNode, GENERATOR);
            if (JSFunctionCustomASTComparator.xorNull(generatorNode, newGeneratorNode = JSFunctionCustomASTComparator.getChildLighterNode(newChildren, newChildrenCount, GENERATOR))) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "fun"));
                }
                return threeState;
            }
            ASTNode oldAttrList = JSFunctionCustomASTComparator.getAttributeListNode(functionNode);
            LighterASTNode newAttrList = JSFunctionCustomASTComparator.getChildLighterNode(newChildren, newChildrenCount, JSStubElementTypes.ATTRIBUTE_LISTS);
            boolean isEmptyOldNode = JSFunctionCustomASTComparator.isEmptyNode(oldAttrList);
            boolean isEmptyNewNode = JSFunctionCustomASTComparator.isEmptyLighterNode(newAttrList);
            if (isEmptyNewNode != isEmptyOldNode) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "fun"));
                }
                return threeState;
            }
            if (!isEmptyNewNode && JSFunctionCustomASTComparator.hasChangesInAttributeList(oldAttrList, structure, newAttrList)) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "fun"));
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "fun"));
        }
        return threeState;
    }

    private static boolean hasChangesInAttributeList(@NotNull ASTNode oldAttrList, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure, @NotNull LighterASTNode newAttrList) {
        if (oldAttrList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldAttrList", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "hasChangesInAttributeList"));
        }
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "hasChangesInAttributeList"));
        }
        if (newAttrList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAttrList", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "hasChangesInAttributeList"));
        }
        return oldAttrList instanceof TreeElement && !((TreeElement)oldAttrList).textMatches(structure.toString((Object)newAttrList));
    }

    private static boolean xorNull(@Nullable ASTNode generatorNode, @Nullable LighterASTNode newGeneratorNode) {
        return generatorNode == null && newGeneratorNode != null || generatorNode != null && newGeneratorNode == null;
    }

    @Nullable
    private static ASTNode getChildNode(@NotNull ASTNode parent, @NotNull TokenSet tokenSet) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "getChildNode"));
        }
        if (tokenSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenSet", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "getChildNode"));
        }
        return (ASTNode)ArrayUtil.getFirstElement((Object[])parent.getChildren(tokenSet));
    }

    @Nullable
    private static LighterASTNode getChildLighterNode(@NotNull LighterASTNode[] children, int count, @NotNull TokenSet tokenSet) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "getChildLighterNode"));
        }
        if (tokenSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenSet", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "getChildLighterNode"));
        }
        for (int i = 0; i < count; ++i) {
            LighterASTNode node = children[i];
            if (node == null || !tokenSet.contains(node.getTokenType())) continue;
            return node;
        }
        return null;
    }

    private static boolean areFunctions(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "areFunctions"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "areFunctions"));
        }
        return JSElementTypes.FUNCTIONS.contains(oldNode.getElementType()) && JSElementTypes.FUNCTIONS.contains(newNode.getTokenType());
    }

    @Contract(value="null -> true")
    private static boolean isEmptyNode(@Nullable ASTNode oldAttrList) {
        return oldAttrList == null || oldAttrList.getTextLength() == 0;
    }

    @Contract(value="null -> true")
    private static boolean isEmptyLighterNode(@Nullable LighterASTNode newAttrList) {
        return newAttrList == null || newAttrList.getStartOffset() == newAttrList.getEndOffset();
    }

    @Nullable
    private static ASTNode getAttributeListNode(@NotNull ASTNode oldNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "com/intellij/lang/javascript/parsing/JSFunctionCustomASTComparator", "getAttributeListNode"));
        }
        Object[] attrLists = oldNode.getChildren(JSStubElementTypes.ATTRIBUTE_LISTS);
        return (ASTNode)ArrayUtil.getFirstElement((Object[])attrLists);
    }
}

