/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSExpressionStatementImpl
extends JSStatementImpl
implements JSExpressionStatement {
    public JSExpressionStatementImpl(IElementType elementType) {
        super(elementType);
    }

    public JSExpression getExpression() {
        ASTNode expressionNode = this.getNode().findChildByType(JSElementTypes.EXPRESSIONS);
        return expressionNode != null ? (JSExpression)expressionNode.getPsi() : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSExpressionStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSExpressionStatement((JSExpressionStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public void clearCaches() {
        super.clearCaches();
        JSExpression expression = this.getExpression();
        while (expression instanceof JSAssignmentExpression) {
            if (!((expression = ((JSAssignmentExpression)expression).getROperand()) instanceof JSFunction)) continue;
            ((JSFunctionBaseImpl)expression).clearCaches();
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        JSExpression expression;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSExpressionStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSExpressionStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSExpressionStatementImpl", "processDeclarations"));
        }
        if (lastParent == null && (expression = this.getExpression()) != null) {
            return expression.processDeclarations(processor, state, lastParent, place);
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return JSExpressionStatementImpl.this.getText();
            }

            public String getLocationString() {
                return "";
            }

            public Icon getIcon(boolean open) {
                return JSExpressionStatementImpl.this.getIcon(0);
            }
        };
    }

    public int getTextOffset() {
        JSExpression expr = this.getExpression();
        if (expr != null) {
            return expr.getTextOffset();
        }
        return super.getTextOffset();
    }
}

