/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSVarStatementImpl
extends JSVarStatementBase {
    private static final Function<ASTNode, List<ASTNode>> GET_VARS = variable -> {
        ASTNode[] children = variable.getChildren(VARIABLES_AND_DESTRUCTURING_CONTAINERS);
        return Arrays.asList(children);
    };
    private static final Function<ASTNode, JSVariable> TO_VAR = var -> {
        PsiElement psi = var.getPsi();
        return psi instanceof JSVariable ? (JSVariable)psi : null;
    };
    private static final Function<StubBasedPsiElementBase, List<StubBasedPsiElementBase>> GET_STUB_SAFE_VARS = variable -> {
        PsiElement[] children = variable.getStubOrPsiChildren(VARIABLES_AND_DESTRUCTURING_CONTAINERS, StubBasedPsiElementBase[]::new);
        return Arrays.asList((StubBasedPsiElementBase[])children);
    };
    private static final Function<StubBasedPsiElementBase, JSVariable> TO_STUB_SAFE_VAR = var -> var instanceof JSVariable ? (JSVariable)var : null;

    public JSVarStatementImpl(ASTNode node) {
        super(node);
    }

    public JSVarStatementImpl(JSVarStatementStub node) {
        super(node, (IStubElementType)JSStubElementTypes.VAR_STATEMENT);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (ActionScriptResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)this)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    public JSVariable[] getVariables() {
        JSVariable[] jSVariableArray = JSVarStatementImpl.calcVariables(this.getNode(), GET_VARS, TO_VAR);
        if (jSVariableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "getVariables"));
        }
        return jSVariableArray;
    }

    @NotNull
    public JSVariable[] getStubSafeVariables() {
        JSVariable[] jSVariableArray = JSVarStatementImpl.calcVariables(this, GET_STUB_SAFE_VARS, TO_STUB_SAFE_VAR);
        if (jSVariableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "getStubSafeVariables"));
        }
        return jSVariableArray;
    }

    private static <T> JSVariable[] calcVariables(T root, Function<T, List<T>> getChildren, Function<T, JSVariable> toVar) {
        ArrayDeque<Object> candidates = new ArrayDeque<Object>();
        candidates.add(root);
        ArrayList result = ContainerUtil.newArrayList();
        while (!candidates.isEmpty()) {
            Object poll = candidates.poll();
            JSVariable jsVariable = (JSVariable)toVar.fun(poll);
            if (jsVariable != null) {
                result.add(jsVariable);
                continue;
            }
            List children = (List)getChildren.fun(poll);
            for (int i = children.size() - 1; i >= 0; --i) {
                candidates.addFirst(children.get(i));
            }
        }
        return result.toArray(JSVariable.EMPTY_ARRAY);
    }

    @Override
    protected boolean shouldDirectProcessVariables(@NotNull PsiScopeProcessor processor, PsiElement lastParent) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "shouldDirectProcessVariables"));
        }
        if (super.shouldDirectProcessVariables(processor, lastParent)) {
            return true;
        }
        ASTNode firstChild = this.getNode().getFirstChildNode();
        return firstChild != null && (firstChild.getElementType() == JSTokenTypes.LET_KEYWORD || firstChild.getElementType() == JSTokenTypes.CONST_KEYWORD);
    }

    @Override
    public JSVarStatement.VarKeyword getVarKeyword() {
        ASTNode keyword = this.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS);
        if (keyword == null) {
            return null;
        }
        IElementType elementType = keyword.getElementType();
        if (elementType == JSTokenTypes.VAR_KEYWORD) {
            return JSVarStatement.VarKeyword.VAR;
        }
        if (elementType == JSTokenTypes.LET_KEYWORD) {
            return JSVarStatement.VarKeyword.LET;
        }
        if (elementType == JSTokenTypes.CONST_KEYWORD) {
            return JSVarStatement.VarKeyword.CONST;
        }
        assert (false) : "unsupported var keyword " + keyword.getElementType().toString();
        return null;
    }
}

