/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGenericThisTypeImpl
extends JSTypeBaseImpl {
    @Nullable
    private final JSType myOwnerType;

    public TypeScriptGenericThisTypeImpl(@NotNull JSTypeSource source, @Nullable JSType ownerType) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "<init>"));
        }
        super(source);
        this.myOwnerType = ownerType;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitTypeScriptThisGenericType((JSType)this);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "copyTypeHierarchy"));
        }
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(this.myOwnerType, childTransform);
        if (this.myOwnerType == newType) {
            TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = this;
            if (typeScriptGenericThisTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "copyTypeHierarchy"));
            }
            return typeScriptGenericThisTypeImpl;
        }
        TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = new TypeScriptGenericThisTypeImpl(this.getSource(), newType);
        if (typeScriptGenericThisTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "copyTypeHierarchy"));
        }
        return typeScriptGenericThisTypeImpl;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String className = this.myOwnerType == null ? "" : this.myOwnerType.getTypeText(format);
            String string = "#this(" + className + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "getTypeText"));
            }
            return string;
        }
        if ("this" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "getTypeText"));
        }
        return "this";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        JSType substitute = this.substitute();
        if (substitute != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "isEquivalentToImpl"));
        }
        if (!(type instanceof TypeScriptGenericThisTypeImpl)) {
            return false;
        }
        JSType typeOwnerType = ((TypeScriptGenericThisTypeImpl)type).myOwnerType;
        if (this.myOwnerType != null) {
            return this.myOwnerType.isEquivalentTo(typeOwnerType, processingContext, allowResolve);
        }
        if (typeOwnerType != null) {
            return false;
        }
        PsiElement sourceElement = this.getSource().getSourceElement();
        PsiElement typeSourceElement = type.getSource().getSourceElement();
        return sourceElement == null ? typeSourceElement == null : sourceElement.isEquivalentTo(typeSourceElement);
    }

    @Override
    @NotNull
    public JSType substitute() {
        if (this.myOwnerType != null) {
            JSType jSType = this.myOwnerType;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "substitute"));
            }
            return jSType;
        }
        TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = this;
        if (typeScriptGenericThisTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "substitute"));
        }
        return typeScriptGenericThisTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "copyWithNewSource"));
        }
        TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = new TypeScriptGenericThisTypeImpl(source, this.myOwnerType);
        if (typeScriptGenericThisTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptGenericThisTypeImpl", "copyWithNewSource"));
        }
        return typeScriptGenericThisTypeImpl;
    }
}

