/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseInplaceIntroducer<S extends BaseIntroduceSettings>
extends AbstractInplaceIntroducer<JSVariable, JSExpression> {
    protected final JSBaseIntroduceHandler<? extends JSElement, S, ? extends JSBaseIntroduceDialog> myIntroduceHandler;
    protected JSBaseIntroduceHandler.BaseIntroduceContext<S> myContext;
    protected final S myInitialSettings;
    private RangeMarker myVarMarker;
    private PsiFile myVarFile;
    protected boolean myDeleteSelf = true;

    public JSBaseInplaceIntroducer(Project project, Editor editor, JSExpression expr, JSExpression[] occurrences, FileType languageFileType, JSBaseIntroduceHandler<? extends JSElement, S, ? extends JSBaseIntroduceDialog> introduceHandler, JSBaseIntroduceHandler.BaseIntroduceContext<S> introduceContext) {
        super(project, editor, (PsiElement)expr, null, (PsiElement[])occurrences, RefactoringBundle.message((String)"introduce.variable.title"), languageFileType);
        this.myIntroduceHandler = introduceHandler;
        this.myContext = introduceContext;
        this.myInitialSettings = this.myContext.settings;
    }

    protected String getActionName() {
        return this.myTitle;
    }

    protected String[] suggestNames(boolean replaceAll, @Nullable JSVariable variable) {
        BasicIntroducedEntityInfoProvider provider = new BasicIntroducedEntityInfoProvider((JSExpression)this.myExpr, (JSExpression[])this.myOccurrences, this.myScope);
        return provider.suggestCandidateNames();
    }

    @Nullable
    protected JSVariable createFieldToStartTemplateOn(boolean replaceAll, String[] names) {
        if (!((JSExpression)this.myContext.expressionDescriptor.first).isValid()) {
            this.fixContext();
        }
        JSVariable jsVariable = (JSVariable)WriteAction.compute(() -> {
            JSBaseIntroduceHandler.IntroduceInfo info = this.startRefactoring();
            if (info == null || info.createdVariable == null) {
                return null;
            }
            JSVariable jsVariable1 = info.createdVariable;
            JSExpression expression = info.expression;
            if (expression != null) {
                this.myExpr = expression;
                this.myExprMarker = this.createMarker(this.myExpr);
            }
            try {
                this.myDeleteSelf = false;
                this.restoreState(jsVariable1);
            }
            finally {
                this.myDeleteSelf = true;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
            return info.createdVariable;
        });
        this.myVarMarker = this.myEditor.getDocument().createRangeMarker(jsVariable.getTextRange());
        this.myVarFile = jsVariable.getContainingFile();
        return jsVariable;
    }

    public JSBaseIntroduceHandler.IntroduceInfo startRefactoring() {
        return this.myIntroduceHandler.doRefactoring(this.myProject, this.myEditor, this.myContext, false);
    }

    protected abstract S getInplaceIntroduceSettings(String var1);

    protected void performCleanup() {
        JSVariable variable = this.getVariable();
        if (variable != null) {
            super.restoreState((PsiNameIdentifierOwner)variable);
        }
    }

    protected void performIntroduce() {
        Runnable runnable = () -> this.myIntroduceHandler.performIntroduce(this.myContext);
        ApplicationManager.getApplication().runWriteAction(runnable);
    }

    private void fixContext() {
        LOG.assertTrue(((JSExpression)this.myExpr).isValid());
        this.myContext = new JSBaseIntroduceHandler.BaseIntroduceContext<S>((Pair<JSExpression, TextRange>)Pair.create((Object)this.myExpr, (Object)this.myContext.expressionDescriptor.second), JSBaseInplaceIntroducer.ensureExpressionInArray((JSExpression[])this.getOccurrences(), (JSExpression)this.myExpr), this.myContext.scope, this.getInplaceIntroduceSettings(this.getInputName()));
    }

    private static JSExpression[] ensureExpressionInArray(JSExpression[] array, JSExpression element) {
        for (JSExpression o : array) {
            if (element != o) continue;
            return array;
        }
        JSExpression[] newArray = new JSExpression[array.length + 1];
        newArray[0] = element;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    protected PsiElement checkLocalScope() {
        PsiElement element = super.checkLocalScope();
        return element == null || element instanceof PsiDirectory ? this.myElementToRename.getContainingFile() : element;
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file) {
        return JSRefactoringUtil.getElementSearchScope((PsiElement)this.myElementToRename);
    }

    public boolean isReplaceAllOccurrences() {
        return this.myInitialSettings.isReplaceAllOccurrences();
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected void saveSettings(@NotNull JSVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/refactoring/introduce/JSBaseInplaceIntroducer", "saveSettings"));
        }
    }

    protected JSVariable getVariable() {
        JSVariable variable;
        if (this.myVarMarker == null) {
            return null;
        }
        if (!this.myVarFile.isValid()) {
            return null;
        }
        PsiElement element = this.myVarFile.getContainingFile().findElementAt(this.myVarMarker.getStartOffset());
        if (element instanceof PsiWhiteSpace) {
            element = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        }
        if ((variable = (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)element, JSVariable.class, (boolean)false)) != null) {
            return variable;
        }
        element = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        return (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)element, JSVariable.class, (boolean)false);
    }

    public JSExpression restoreExpression(PsiFile containingFile, JSVariable variable, RangeMarker marker, String exprText) {
        if (exprText == null || variable == null) {
            return null;
        }
        PsiElement elementAt = containingFile.findElementAt(marker.getStartOffset());
        if (elementAt == null) {
            return null;
        }
        PsiElement parent = elementAt.getParent();
        JSExpression candidateExpression = null;
        if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getVariables();
            if (variables.length == 1) {
                candidateExpression = variables[0].getInitializer();
            }
        } else if (parent instanceof JSExpression) {
            candidateExpression = (JSExpression)parent;
        }
        JSReferenceExpression result = null;
        if (candidateExpression instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)candidateExpression;
            String referenceName = refExpr.getReferenceName();
            if (Comparing.strEqual((String)exprText, (String)referenceName)) {
                result = refExpr;
            } else if (refExpr.resolve() == variable || Comparing.strEqual((String)variable.getName(), (String)referenceName)) {
                JSExpression newExpression = (JSExpression)JSInheritedLanguagesHelper.createExpressionFromText(exprText, (PsiElement)variable, true);
                result = refExpr.replace(newExpression);
            }
        }
        if (result == null) {
            JSExpression expression;
            JSExpression jSExpression = expression = candidateExpression != null ? candidateExpression : (JSExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementAt, (Class[])new Class[]{JSExpression.class});
            while (expression != null) {
                if (expression.getText().equals(exprText)) {
                    return expression;
                }
                expression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, JSExpression.class);
            }
        }
        LOG.assertTrue(result == null || result.isValid());
        return result;
    }

    protected void deleteTemplateField(JSVariable psiField) {
        if (!this.myDeleteSelf) {
            return;
        }
        if (psiField.isValid()) {
            psiField.delete();
        }
    }

    protected void restoreState(@NotNull JSVariable psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/lang/javascript/refactoring/introduce/JSBaseInplaceIntroducer", "restoreState"));
        }
        if (this.myDeleteSelf) {
            return;
        }
        super.restoreState((PsiNameIdentifierOwner)psiField);
    }

    protected boolean ensureValid() {
        return true;
    }
}

