/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSSymbolPresentationUtils;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentationBase;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PlatformIcons;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructureItemPresentation
extends JSStructureItemPresentationBase {
    public static final String ANONYMOUS = "<anonymous>";
    public static final String DEFAULT_MEMBER_NAME = "<default>";
    private long modificationCount;
    private String myPresentableText;
    private PsiModificationTracker myTracker;
    private static final Map<String, Icon> myQNameToIconMap = new THashMap();
    private static long myQNameToIconModificationCount;

    public JSStructureItemPresentation(JSStructureViewElement jsStructureViewElement) {
        super(jsStructureViewElement);
    }

    public String getPresentableText() {
        long current;
        PsiElement psiElement = this.element.getValue();
        if (psiElement == null) {
            return "*invalid*";
        }
        long l = current = this.myTracker != null ? this.myTracker.getModificationCount() : -1L;
        if (this.modificationCount != current) {
            boolean valid = psiElement.isValid();
            this.myTracker = valid ? psiElement.getManager().getModificationTracker() : null;
            this.myPresentableText = valid ? this.buildPresentationForElement(psiElement) : "*invalid*";
            this.modificationCount = current;
        }
        return this.myPresentableText;
    }

    @Nullable
    protected String buildPresentationForElement(PsiElement psiElement) {
        JSType type;
        if (psiElement instanceof JSObjectLiteralExpression) {
            if (psiElement.getParent() instanceof JSAssignmentExpression) {
                JSExpression expression = ((JSDefinitionExpression)((JSAssignmentExpression)psiElement.getParent()).getLOperand()).getExpression();
                JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(expression);
                return ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : expression.getText();
            }
            return JSBundle.message((String)"javascript.language.term.prototype", (Object[])new Object[0]);
        }
        if (psiElement instanceof JSReferenceExpression) {
            JSExpression jsExpression;
            JSReferenceExpression expression = (JSReferenceExpression)psiElement;
            String s = expression.getReferencedName();
            if ("prototype".equals(s) && (jsExpression = expression.getQualifier()) instanceof JSReferenceExpression) {
                s = ((JSReferenceExpression)jsExpression).getReferencedName();
            }
            return s;
        }
        if (!(psiElement instanceof PsiNamedElement)) {
            return psiElement.getText();
        }
        String name = psiElement instanceof JSPsiNamedElementBase ? JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)psiElement, true) : ((PsiNamedElement)psiElement).getName();
        if (psiElement instanceof JSProperty) {
            psiElement = ((JSProperty)psiElement).tryGetFunctionInitializer();
        }
        boolean function = false;
        if (psiElement instanceof JSFunctionItem) {
            if (name == null) {
                name = JSStructureItemPresentation.getAnonymousName(psiElement);
            }
            name = name + JSSymbolPresentationUtils.buildFunctionSignaturePresentation((JSFunctionItem)psiElement);
        } else if (psiElement instanceof JSImplicitElement && ((JSImplicitElement)psiElement).getType() == JSImplicitElement.Type.Function) {
            function = true;
        }
        if (psiElement instanceof JSVariable && (type = ((JSVariable)psiElement).getType()) != null && !(type instanceof JSTypeofTypeImpl)) {
            name = name + ":" + type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }
        if (name == null && psiElement != null && psiElement.getParent() instanceof JSAssignmentExpression) {
            JSExpression lOperand = ((JSDefinitionExpression)((JSAssignmentExpression)psiElement.getParent()).getLOperand()).getExpression();
            JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(lOperand);
            return ns != null && ns.getSource() instanceof JSReferenceExpression ? ((JSReferenceExpression)ns.getSource()).getReferenceName() : (lOperand != null ? lOperand.getText() : null);
        }
        if (name != null && psiElement instanceof JSDefinitionExpression && ((JSDefinitionExpression)psiElement).getInitializerOrStub() instanceof JSFunction) {
            name = name + "()";
        }
        if (function) {
            name = name + "()";
        }
        return name;
    }

    public Icon getIcon(boolean open) {
        Icon icon;
        int flags = 1;
        PsiElement psiElement = this.element.getValue();
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        if (psiElement instanceof JSImplicitElement) {
            return ((ItemPresentation)psiElement).getIcon(open);
        }
        if (psiElement instanceof JSParameter) {
            return PlatformIcons.FIELD_ICON;
        }
        if (psiElement instanceof JSReferenceExpression) {
            return PlatformIcons.VARIABLE_ICON;
        }
        if (psiElement instanceof XmlAttributeValue && (icon = JSStructureItemPresentation.getIcon((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class))) != null) {
            return icon;
        }
        if (psiElement instanceof JSFunctionItem) {
            boolean isProperty;
            boolean bl = isProperty = ((JSFunctionItem)psiElement).isGetProperty() || ((JSFunctionItem)psiElement).isSetProperty();
            if (isProperty) {
                boolean hasSetProperty = false;
                boolean hasGetProperty = false;
                for (PsiElement e : this.element.getAllElements()) {
                    hasSetProperty |= e instanceof JSFunctionItem && ((JSFunctionItem)e).isSetProperty();
                    hasGetProperty |= e instanceof JSFunctionItem && ((JSFunctionItem)e).isGetProperty();
                }
                if (hasGetProperty && hasSetProperty) {
                    Icon initialIcon = ((JSFunctionItem)psiElement).getJSContext() == JSContext.STATIC ? AllIcons.Nodes.PropertyReadWriteStatic : AllIcons.Nodes.PropertyReadWrite;
                    JSAttributeList list = psiElement instanceof JSAttributeListOwner ? ((JSAttributeListOwner)psiElement).getAttributeList() : null;
                    return list != null ? ElementBase.iconWithVisibilityIfNeeded((int)flags, (Icon)initialIcon, (Icon)list.getAccessType().getIcon()) : initialIcon;
                }
            }
        }
        return psiElement.getIcon(flags);
    }

    @Nullable
    public static Icon getIcon(XmlTag tag) {
        if (tag == null) {
            return null;
        }
        if (JavaScriptSupportLoader.isFlexMxmFile(tag.getContainingFile())) {
            Icon icon;
            long count = tag.getManager().getModificationTracker().getModificationCount();
            String tagName = tag.getName();
            if (myQNameToIconModificationCount == count) {
                icon = myQNameToIconMap.get(tagName);
                if (icon != null) {
                    return icon;
                }
                if (myQNameToIconMap.containsKey(tagName)) {
                    return null;
                }
            } else {
                myQNameToIconMap.clear();
                myQNameToIconModificationCount = count;
            }
            icon = JSStructureItemPresentation.findIcon(tag);
            myQNameToIconMap.put(tagName, icon);
            return icon;
        }
        return null;
    }

    private static Icon findIcon(XmlTag tag) {
        XmlElementDescriptor descriptor2;
        JSAttributeNameValuePair pair;
        JSAttribute[] attrs;
        JSAttributeList attributeList;
        JSClass aClass = JSResolveUtil.getClassFromTagNameInMxml(tag.getFirstChild());
        if (aClass != null && (attributeList = aClass.getAttributeList()) != null && (attrs = attributeList.getAttributesByName("IconFile")).length > 0 && (pair = attrs[0].getValueByName(null)) != null) {
            String s = pair.getSimpleValue();
            VirtualFile file = aClass.getContainingFile().getVirtualFile();
            if (file != null) {
                VirtualFile child;
                VirtualFile parent = file.getParent();
                VirtualFile virtualFile = child = parent != null && s != null ? parent.findChild(s) : null;
                if (child != null) {
                    return new ImageIcon(child.getPath());
                }
            }
        }
        if ((descriptor2 = tag.getDescriptor()) instanceof IconProvider && aClass != null) {
            return ((IconProvider)descriptor2).getIcon((PsiElement)aClass, 0);
        }
        return null;
    }

    @NotNull
    protected static String getAnonymousName(PsiElement psiElement) {
        PsiElement parent = psiElement.getParent();
        if (parent instanceof ES6ExportDefaultAssignment) {
            if (DEFAULT_MEMBER_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSStructureItemPresentation", "getAnonymousName"));
            }
            return DEFAULT_MEMBER_NAME;
        }
        if (ANONYMOUS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSStructureItemPresentation", "getAnonymousName"));
        }
        return ANONYMOUS;
    }
}

