/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.intentions.ES6ReplaceImportFromClauseFix;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptPreferShortImportInspection
extends JSInspection {
    public static final String SHORT_NAME = TypeScriptPreferShortImportInspection.calcShortNameFromClass(TypeScriptPreferShortImportInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
                if (importDeclaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDeclaration", "com/intellij/lang/typescript/inspection/TypeScriptPreferShortImportInspection$1", "visitES6ImportDeclaration"));
                }
                TypeScriptPreferShortImportInspection.inspectImport(holder, importDeclaration);
                super.visitES6ImportDeclaration(importDeclaration);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/inspection/TypeScriptPreferShortImportInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static void inspectImport(ProblemsHolder holder, ES6ImportDeclaration importDeclaration) {
        boolean toProcess;
        if (!DialectDetector.isTypeScript((PsiElement)importDeclaration)) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!ArrayUtil.isEmpty((Object[])importDeclaration.getImportedBindings())) {
            return;
        }
        Object[] specifiers = importDeclaration.getImportSpecifiers();
        if (ArrayUtil.isEmpty((Object[])specifiers)) {
            return;
        }
        ArrayList elements = ContainerUtil.newArrayList();
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return;
        }
        String text = StringUtil.notNullize((String)clause.getReferenceText());
        String unquotedOldText = StringUtil.unquoteString((String)text);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        boolean bl = toProcess = unquotedOldText.startsWith(".") || unquotedOldText.endsWith("index");
        if (!toProcess) {
            return;
        }
        Collection refElements = clause.resolveReferencedElements();
        if (refElements.isEmpty()) {
            return;
        }
        if (!TypeScriptPreferShortImportInspection.fillSpecifierElements((ES6ImportSpecifier[])specifiers, elements) || elements.isEmpty()) {
            return;
        }
        JSQualifiedNamedElement item = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((List)elements);
        assert (item != null);
        Project project = importDeclaration.getProject();
        JSModuleNameInfo info = TypeScriptAutoImportUtil.getExternalFileModuleName(project, (JSElement)item, (PsiElement)importDeclaration);
        ProgressIndicatorProvider.checkCanceled();
        if (info == null) {
            return;
        }
        String unquotedNewName = info.getModuleName();
        if (unquotedNewName.length() >= StringUtil.trimEnd((String)unquotedOldText, (String)"/").length()) {
            return;
        }
        if (unquotedNewName.equals("./") || unquotedNewName.equals("../")) {
            return;
        }
        List sublist = elements.subList(1, elements.size());
        VirtualFile module = info.getModule();
        PsiFile currentFile = importDeclaration.getContainingFile();
        if (module == null || module.equals(currentFile.getVirtualFile())) {
            return;
        }
        for (JSQualifiedNamedElement elementToImport : sublist) {
            if (ES6CreateImportUtil.checkSymbolInFile(project, module, (JSElement)elementToImport, (PsiElement)currentFile)) continue;
            return;
        }
        ASTNode node = clause.getNode();
        ASTNode literalNode = node.findChildByType(JSTokenTypes.STRING_LITERALS);
        if (literalNode == null) {
            return;
        }
        holder.registerProblem(literalNode.getPsi(), JSBundle.message((String)"typescript.prefer.short.import.name", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ReplaceImportFromClauseFix((ES6ImportExportDeclaration)importDeclaration, unquotedNewName)});
    }

    private static boolean fillSpecifierElements(@NotNull ES6ImportSpecifier[] specifiers, @NotNull List<JSQualifiedNamedElement> elements) {
        if (specifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifiers", "com/intellij/lang/typescript/inspection/TypeScriptPreferShortImportInspection", "fillSpecifierElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/typescript/inspection/TypeScriptPreferShortImportInspection", "fillSpecifierElements"));
        }
        for (ES6ImportSpecifier specifier : specifiers) {
            ResolveResult[] results = specifier.resolveOverAliases();
            Collection<PsiElement> candidates = JSResolveResult.toElements(results);
            for (PsiElement candidate : candidates) {
                if (candidate instanceof JSQualifiedNamedElement) {
                    elements.add((JSQualifiedNamedElement)candidate);
                    continue;
                }
                return false;
            }
        }
        return true;
    }
}

