/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.assignment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class SillyAssignmentJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("silly.assignment.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/SillyAssignmentJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.ASSIGNMENT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/SillyAssignmentJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("silly.assignment.error.string", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
            String lhsQualifierText;
            JSExpression rhs;
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/sixrr/inspectjs/assignment/SillyAssignmentJSInspection$Visitor", "visitJSAssignmentExpression"));
            }
            super.visitJSAssignmentExpression(assignment);
            IElementType sign = assignment.getOperationSign();
            if (!JSTokenTypes.EQ.equals(sign)) {
                return;
            }
            JSExpression lhs = assignment.getLOperand();
            if (lhs instanceof JSDefinitionExpression) {
                lhs = ((JSDefinitionExpression)lhs).getExpression();
            }
            if ((rhs = assignment.getROperand()) == null || lhs == null) {
                return;
            }
            if (!(rhs instanceof JSReferenceExpression) || !(lhs instanceof JSReferenceExpression)) {
                return;
            }
            JSReferenceExpression rhsReference = (JSReferenceExpression)rhs;
            JSReferenceExpression lhsReference = (JSReferenceExpression)lhs;
            JSExpression rhsQualifier = rhsReference.getQualifier();
            JSExpression lhsQualifier = lhsReference.getQualifier();
            if (!(rhsQualifier == null && lhsQualifier == null || EquivalenceChecker.expressionsAreEquivalent(rhsQualifier, lhsQualifier))) {
                return;
            }
            String rhsName = rhsReference.getReferencedName();
            String lhsName = lhsReference.getReferencedName();
            if (rhsName == null || lhsName == null) {
                return;
            }
            if (!rhsName.equals(lhsName)) {
                return;
            }
            PsiElement rhsReferent = rhsReference.resolve();
            PsiElement lhsReferent = lhsReference.resolve();
            if (rhsReferent != null && lhsReferent != null && !rhsReferent.equals(lhsReferent)) {
                return;
            }
            if (lhsName.equals("location") && lhsQualifier != null && ((lhsQualifierText = lhsQualifier.getText()).equals("document") || "window".equals(lhsQualifierText))) {
                return;
            }
            this.registerError((PsiElement)assignment);
        }
    }
}

