/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PointlessArithmeticExpressionJSInspection
extends JavaScriptInspection {
    private final PointlessArithmeticFix fix = new PointlessArithmeticFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("pointless.arithmetic.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/PointlessArithmeticExpressionJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONFUSING_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/PointlessArithmeticExpressionJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("pointless.arithmetic.error.message", PointlessArithmeticExpressionJSInspection.calculateReplacementExpression((JSExpression)args[0]));
    }

    private static String calculateReplacementExpression(JSExpression expression) {
        JSBinaryExpression exp = (JSBinaryExpression)expression;
        IElementType sign = exp.getOperationSign();
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        assert (rhs != null);
        if (JSTokenTypes.PLUS.equals(sign)) {
            if (PointlessArithmeticExpressionJSInspection.isZero(lhs)) {
                return rhs.getText();
            }
            return lhs.getText();
        }
        if (JSTokenTypes.MINUS.equals(sign)) {
            return lhs.getText();
        }
        if (JSTokenTypes.MULT.equals(sign)) {
            if (PointlessArithmeticExpressionJSInspection.isOne(lhs)) {
                return rhs.getText();
            }
            if (PointlessArithmeticExpressionJSInspection.isOne(rhs)) {
                return lhs.getText();
            }
            return "0";
        }
        if (JSTokenTypes.DIV.equals(sign)) {
            return lhs.getText();
        }
        return "";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static boolean subtractionExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return PointlessArithmeticExpressionJSInspection.isZero(rhs) && PointlessArithmeticExpressionJSInspection.isNumber(lhs);
    }

    private static boolean additionExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return PointlessArithmeticExpressionJSInspection.isZero(lhs) && PointlessArithmeticExpressionJSInspection.isNumber(rhs) || PointlessArithmeticExpressionJSInspection.isZero(rhs) && PointlessArithmeticExpressionJSInspection.isNumber(lhs);
    }

    private static boolean multiplyExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        if (PointlessArithmeticExpressionJSInspection.isZero(lhs) || PointlessArithmeticExpressionJSInspection.isZero(rhs)) {
            return true;
        }
        return PointlessArithmeticExpressionJSInspection.isOne(lhs) && PointlessArithmeticExpressionJSInspection.isNumber(rhs) || PointlessArithmeticExpressionJSInspection.isOne(rhs) && PointlessArithmeticExpressionJSInspection.isNumber(lhs);
    }

    private static boolean divideExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return PointlessArithmeticExpressionJSInspection.isOne(rhs) && PointlessArithmeticExpressionJSInspection.isNumber(lhs);
    }

    private static boolean isNumber(JSExpression exp) {
        return JSResolveUtil.getExpressionJSType(exp) instanceof JSNumberType;
    }

    private static boolean isZero(JSExpression expression) {
        String text = expression.getText();
        return text.equals("0") || text.equals("0x0") || text.equals("0X0") || text.equals("0.0") || text.equals("0L") || text.equals("0l");
    }

    private static boolean isOne(JSExpression expression) {
        String text = expression.getText();
        return text.equals("1") || text.equals("0x1") || text.equals("0X1") || text.equals("1.0") || text.equals("1L") || text.equals("1l");
    }

    private static class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private final Set<IElementType> arithmeticTokens = new HashSet<IElementType>(4);

        private PointlessArithmeticVisitor() {
            this.arithmeticTokens.add(JSTokenTypes.PLUS);
            this.arithmeticTokens.add(JSTokenTypes.MINUS);
            this.arithmeticTokens.add(JSTokenTypes.MULT);
            this.arithmeticTokens.add(JSTokenTypes.DIV);
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/confusing/PointlessArithmeticExpressionJSInspection$PointlessArithmeticVisitor", "visitJSBinaryExpression"));
            }
            super.visitJSBinaryExpression(expression);
            IElementType sign = expression.getOperationSign();
            if (!this.arithmeticTokens.contains(sign)) {
                return;
            }
            JSExpression rhs = expression.getROperand();
            JSExpression lhs = expression.getLOperand();
            if (rhs == null || lhs == null) {
                return;
            }
            boolean isPointless = sign.equals(JSTokenTypes.PLUS) ? PointlessArithmeticExpressionJSInspection.additionExpressionIsPointless(lhs, rhs) : (sign.equals(JSTokenTypes.MINUS) ? PointlessArithmeticExpressionJSInspection.subtractionExpressionIsPointless(lhs, rhs) : (sign.equals(JSTokenTypes.MULT) ? PointlessArithmeticExpressionJSInspection.multiplyExpressionIsPointless(lhs, rhs) : (sign.equals(JSTokenTypes.DIV) ? PointlessArithmeticExpressionJSInspection.divideExpressionIsPointless(lhs, rhs) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression);
        }
    }

    private static class PointlessArithmeticFix
    extends InspectionJSFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/PointlessArithmeticExpressionJSInspection$PointlessArithmeticFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            JSExpression expression = (JSExpression)descriptor2.getPsiElement();
            String newExpression = PointlessArithmeticExpressionJSInspection.calculateReplacementExpression(expression);
            PointlessArithmeticFix.replaceExpression(expression, newExpression);
        }
    }
}

