/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.V8ValueMarkerProvider;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.PairFunction;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ToggleCaptureAsyncStackTracesAction;
import com.jetbrains.debugger.wip.WipConsoleAPICalled;
import com.jetbrains.debugger.wip.WipConsoleMessageTask;
import com.jetbrains.debugger.wip.WipExceptionThrown;
import com.jetbrains.debugger.wip.WipLogEntry;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.wip.SerializableValue;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.console.MessageAddedEventData;
import org.jetbrains.wip.protocol.log.EntryAddedEventData;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.ExceptionThrownEventData;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0016\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J&\u0010$\u001a\u00020\u001c2\u001e\u0010\u000b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fR&\u0010\u000b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/jetbrains/debugger/wip/ChromeDebugProcess;", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "finder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "connection", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/javascript/debugger/DebuggableFileFinder;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/execution/ExecutionResult;)V", "breakpointLanguageHint", "Lcom/intellij/util/PairFunction;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lorg/jetbrains/debugger/Location;", "", "valueMarkerProvider", "Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;", "getValueMarkerProvider", "()Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;", "valueMarkerProvider$delegate", "Lkotlin/Lazy;", "getBreakpointLanguageHint", "breakpoint", "location", "getCurrentLocationUrl", "Lcom/intellij/util/Url;", "registerAdditionalActions", "", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "resume", "vm", "Lorg/jetbrains/debugger/Vm;", "setBreakpointLanguageHint", "ChromeConnector"})
public class ChromeDebugProcess
extends JavaScriptDebugProcess<VmConnection<?>> {
    private PairFunction<XLineBreakpoint<?>, Location, String> breakpointLanguageHint;
    @NotNull
    private final Lazy valueMarkerProvider$delegate;
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    @Nullable
    public String getBreakpointLanguageHint(@Nullable XLineBreakpoint<?> breakpoint, @NotNull Location location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        PairFunction<XLineBreakpoint<?>, Location, String> pairFunction = this.breakpointLanguageHint;
        return pairFunction != null ? (String)pairFunction.fun(breakpoint, (Object)location) : null;
    }

    public final void setBreakpointLanguageHint(@Nullable PairFunction<XLineBreakpoint<?>, Location, String> breakpointLanguageHint) {
        this.breakpointLanguageHint = breakpointLanguageHint;
    }

    @Nullable
    public Url getCurrentLocationUrl() {
        WipVm wipVm = (WipVm)this.getActiveOrMainVm();
        return wipVm != null ? wipVm.getCurrentUrl() : null;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        Intrinsics.checkParameterIsNotNull((Object)leftToolbar, (String)"leftToolbar");
        Intrinsics.checkParameterIsNotNull((Object)topToolbar, (String)"topToolbar");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        topToolbar.add((AnAction)new ToggleCaptureAsyncStackTracesAction());
    }

    @NotNull
    public V8ValueMarkerProvider getValueMarkerProvider() {
        Lazy lazy = this.valueMarkerProvider$delegate;
        ChromeDebugProcess chromeDebugProcess = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (V8ValueMarkerProvider)lazy.getValue();
    }

    public void resume(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        this.continueVm(vm, StepAction.CONTINUE);
    }

    public ChromeDebugProcess(@NotNull XDebugSession session2, @NotNull DebuggableFileFinder finder, @NotNull VmConnection<?> connection, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)finder, (String)"finder");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        super(session2, finder, connection, executionResult);
        connection.executeOnStart(new Runnable(){

            @Override
            public final void run() {
                Vm vm = this.getMainVm();
                if (vm == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
                }
                WipVm vm2 = (WipVm)vm;
                Function1 messageGetter2 = (Function1)new Function1<Object, ConsoleMessage>(vm2){
                    final /* synthetic */ WipVm $vm;

                    @NotNull
                    public final ConsoleMessage invoke(@NotNull Object message) {
                        ConsoleMessage consoleMessage;
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Object object = message;
                        if (object instanceof ConsoleAPICalledEventData) {
                            consoleMessage = new WipConsoleAPICalled((ConsoleAPICalledEventData)message);
                        } else if (object instanceof EntryAddedEventData) {
                            consoleMessage = new WipLogEntry(((EntryAddedEventData)message).entry(), this.$vm.getNetworkManager().getRequest(((EntryAddedEventData)message).entry().getNetworkRequestId()));
                        } else if (object instanceof ExceptionThrownEventData) {
                            consoleMessage = new WipExceptionThrown((ExceptionThrownEventData)message);
                        } else if (object instanceof MessageAddedEventData) {
                            consoleMessage = new WipConsoleMessageTask(((MessageAddedEventData)message).message(), this.$vm.getNetworkManager().getRequest(((MessageAddedEventData)message).message().getNetworkRequestId()));
                        } else {
                            throw (Throwable)new IllegalArgumentException(message.getClass().getName());
                        }
                        return consoleMessage;
                    }
                    {
                        this.$vm = wipVm;
                        super(1);
                    }
                };
                Object[] elements$iv = new EventType[]{ConsoleAPICalledEventData.TYPE, EntryAddedEventData.TYPE, ExceptionThrownEventData.TYPE, MessageAddedEventData.TYPE};
                Object[] $receiver$iv = elements$iv;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    EventType it = (EventType)element$iv;
                    vm2.getCommandProcessor().getEventMap().add(it, (Function1)new Function1<Object, Unit>(this, vm2, messageGetter2){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ WipVm $vm$inlined;
                        final /* synthetic */ Function1 $messageGetter$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$vm$inlined = wipVm;
                            this.$messageGetter$inlined = function1;
                            super(1);
                        }

                        public final void invoke(Object it) {
                            ChromeDebugProcess.access$getConsolePrinter$p(this.this$0.this).addMessage(it, (Function2)1.1.INSTANCE, this.$messageGetter$inlined);
                        }
                    });
                }
                if (JavaScriptDebuggerSettings.getInstance().isCaptureAsyncStackTraces()) {
                    vm2.setCaptureAsyncStackTraces(true);
                }
            }
        });
        connection.addDebugListener(new DebugEventListener(){

            public void navigated(@NotNull String newUrl) {
                Intrinsics.checkParameterIsNotNull((Object)newUrl, (String)"newUrl");
                this.getConsolePrinter().clear();
            }
        });
        this.valueMarkerProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<valueMarkerProvider.1>(this){
            final /* synthetic */ ChromeDebugProcess this$0;

            @NotNull
            public final valueMarkerProvider.1 invoke() {
                return new V8ValueMarkerProvider(this, this.this$0){
                    final /* synthetic */ valueMarkerProvider.2 this$0;

                    @Nullable
                    public String getRefId(@Nullable Value value) {
                        return value instanceof SerializableValue ? ((SerializableValue)value).getRefId() : null;
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1);
                    }
                };
            }
            {
                this.this$0 = chromeDebugProcess;
                super(0);
            }
        }));
    }

    public /* synthetic */ ChromeDebugProcess(XDebugSession xDebugSession, DebuggableFileFinder debuggableFileFinder, VmConnection vmConnection, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executionResult = null;
        }
        this(xDebugSession, debuggableFileFinder, vmConnection, executionResult);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ChromeDebugProcess.class), "valueMarkerProvider", "getValueMarkerProvider()Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;"))};
    }
}

