/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.SyntheticSuspendBreakpointInfo;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.nodeJs.NodeJSFileFinderKt;
import com.jetbrains.nodeJs.NodeJsDebugProcessBaseKt;
import com.jetbrains.nodeJs.NodeJsDebuggerViewSupport;
import java.io.File;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.v8.V8Vm;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0014J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 H\u0014J\u001e\u0010$\u001a\u0004\u0018\u00010%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010(\u001a\u00020\nH\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/jetbrains/nodeJs/NodeJsDebugProcessBase;", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "connection", "Lorg/jetbrains/debugger/Vm;", "fileFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "isBreakOnFirstLine", "", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/javascript/debugger/DebuggableFileFinder;ZLcom/intellij/execution/ExecutionResult;)V", "isFilesOnlyInLocalFileSystem", "()Z", "beforeInitBreakpoints", "", "vm", "checkCanInitBreakpoints", "configureConsoleFilers", "console", "Lcom/intellij/execution/ui/ConsoleView;", "createDebuggerViewSupport", "Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "doFindSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "script", "Lorg/jetbrains/debugger/Script;", "findSourceMap", "findSourceMapBeforeAdd", "sourceMapUrl", "", "getBreakpointFileUrl", "Lcom/intellij/util/Url;", "ideaUrl", "getSyntheticSuspend", "Lcom/intellij/javascript/debugger/SyntheticSuspendBreakpointInfo;", "context", "Lorg/jetbrains/debugger/SuspendContext;", "isLineRelationshipComputable", "ChromeConnector"})
public abstract class NodeJsDebugProcessBase
extends JavaScriptDebugProcess<VmConnection<?>> {
    private final boolean isFilesOnlyInLocalFileSystem = true;
    private final boolean isBreakOnFirstLine;

    @NotNull
    protected JavaScriptDebuggerViewSupport createDebuggerViewSupport() {
        return new NodeJsDebuggerViewSupport(this);
    }

    protected boolean isLineRelationshipComputable() {
        return false;
    }

    public boolean isFilesOnlyInLocalFileSystem() {
        return this.isFilesOnlyInLocalFileSystem;
    }

    @NotNull
    protected Url getBreakpointFileUrl(@NotNull String ideaUrl) {
        Intrinsics.checkParameterIsNotNull((Object)ideaUrl, (String)"ideaUrl");
        return Urls.newLocalFileUrl((String)VirtualFileManager.extractPath((String)ideaUrl));
    }

    public boolean checkCanInitBreakpoints() {
        return !this.isBreakOnFirstLine && super.checkCanInitBreakpoints();
    }

    protected void beforeInitBreakpoints(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        if (Registry.is((String)"js.debugger.v8.use.any.breakpoint", (boolean)true)) {
            String regExp = "^(?:\\/|(?:[\\w]:))(?!.+[\\/|\\\\]node_modules[\\/|\\\\].+).+\\.js$";
            String condition = Intrinsics.areEqual((Object)"jar", (Object)V8Vm.class.getResource("").getProtocol()) ? NodeJsDebugProcessBaseKt.access$getANY_BREAKPOINT_CONDITION$p() : FilesKt.readText$default((File)new File(PathManager.getPreInstalledPluginsPath(), FileUtil.toSystemDependentName((String)"JavaScriptDebugger/ChromeConnector/source/com/jetbrains/nodeJs/testCondition.js")), null, (int)1, null);
            this.getLineBreakpointManager().setAnyFirstLineBreakpoint(vm, regExp, condition);
        }
        super.beforeInitBreakpoints(vm);
    }

    @Nullable
    protected SyntheticSuspendBreakpointInfo getSyntheticSuspend(@NotNull SuspendContext<?> context, @NotNull Script script) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Vm vm = context.getVm();
        if (this.isBreakOnFirstLine && context.getBreakpointsHit().isEmpty() && vm.replace(NodeJsDebugProcessBaseKt.getFirstSyntheticSuspendProcessedKey(), null, (Object)true)) {
            this.initBreakpoints(true);
            XLineBreakpoint breakpoint = null;
            if (script.getLine() == 0) {
                Object v2;
                block4: {
                    this.findSourceMap(vm, script);
                    JavaScriptLineBreakpointManager javaScriptLineBreakpointManager = this.getLineBreakpointManager();
                    String string = script.getUrl().toExternalForm();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.url.toExternalForm()");
                    Iterable $receiver$iv = javaScriptLineBreakpointManager.findTopFirstLineBreakpoints(context, string);
                    for (Object element$iv : $receiver$iv) {
                        XLineBreakpoint it = (XLineBreakpoint)element$iv;
                        if (!this.isActualBreakFile((XBreakpoint)it, script)) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                breakpoint = v2;
            }
            if (breakpoint == null) {
                this.resume(vm);
                return SyntheticSuspendBreakpointInfo.SKIP;
            }
            return new SyntheticSuspendBreakpointInfo(breakpoint);
        }
        return this.processBreakpointsHit(context, script, (Function1)new Function1<Script, Unit>(this, vm){
            final /* synthetic */ NodeJsDebugProcessBase this$0;
            final /* synthetic */ Vm $vm;

            public final void invoke(@NotNull Script it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                NodeJsDebugProcessBase.access$findSourceMap(this.this$0, this.$vm, it);
            }
            {
                this.this$0 = nodeJsDebugProcessBase;
                this.$vm = vm;
                super(1);
            }
        });
    }

    @Nullable
    protected SourceMap findSourceMapBeforeAdd(@NotNull Vm vm, @NotNull Script script, @Nullable String sourceMapUrl) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        if (sourceMapUrl == null && script.getSourceMap() == null && vm instanceof V8Vm && !((V8Vm)vm).getBootstrapped() && !((V8Vm)vm).getHasJbDebuggerSupport()) {
            return this.doFindSourceMap(vm, script);
        }
        return super.findSourceMapBeforeAdd(vm, script, sourceMapUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SourceMap doFindSourceMap(Vm vm, Script script) {
        V8Vm v8Vm;
        V8Vm it;
        if (script.getSourceMap() != null) return null;
        Vm vm2 = vm;
        if (!(vm2 instanceof V8Vm)) {
            vm2 = null;
        }
        if ((it = (v8Vm = (V8Vm)vm2)) != null && it.isAbleToReportSourceMapUrl()) {
            return null;
        }
        boolean bl = false;
        if (bl) {
            return null;
        }
        if (script.getUrl().isInLocalFileSystem() && !NodeJSFileFinderKt.isModuleName(script.getUrl())) {
            return SourceMapLoaderKt.findSourceMapLocally((Script)script, (JavaScriptDebugProcess)this);
        }
        CharSequence sourceMapData = null;
        Url normalizedUrl = null;
        VirtualFile virtualFile = this.findFile(script);
        if (virtualFile == null) return null;
        VirtualFile scriptFile = virtualFile;
        String url = SourceMapLoaderKt.getSourceMapUrl((VirtualFile)scriptFile);
        if (url == null) {
            VirtualFile file = scriptFile.getParent().findChild("" + scriptFile.getName() + ".map");
            if (file == null) return null;
            if (file.getTimeStamp() + (long)100 < scriptFile.getTimeStamp()) return null;
            normalizedUrl = Urls.newLocalFileUrl((VirtualFile)file);
            return this.decodeSourceMap(normalizedUrl, sourceMapData, script);
        } else {
            CharSequence charSequence = url;
            if (charSequence.length() == 0) {
                return null;
            }
            boolean bl2 = false;
            if (bl2) {
                return null;
            }
            if (URLUtil.isDataUri((String)url)) {
                sourceMapData = SourceMapLoaderKt.loadFromDataUri((String)url, (Url)script.getUrl(), (XDebugSession)this.getSession());
                return this.decodeSourceMap(normalizedUrl, sourceMapData, script);
            } else {
                if (!Paths.get(url, new String[0]).isAbsolute()) {
                    url = "" + scriptFile.getParent().getPath() + '/' + url;
                }
                normalizedUrl = Urls.newLocalFileUrl((String)FileUtil.toCanonicalPath((String)url, (char)'/'));
            }
        }
        return this.decodeSourceMap(normalizedUrl, sourceMapData, script);
    }

    private final void findSourceMap(Vm vm, Script script) {
        block0: {
            SourceMap sourceMap;
            SourceMap sourceMap2 = this.doFindSourceMap(vm, script);
            if (sourceMap2 == null) break block0;
            SourceMap it = sourceMap = sourceMap2;
            JavaScriptDebugProcess.sourceMapFound$default((JavaScriptDebugProcess)this, (Vm)vm, (SourceMap)it, (Script)script, null, null, (int)24, null);
        }
    }

    protected void configureConsoleFilers(@NotNull ConsoleView console) {
        Intrinsics.checkParameterIsNotNull((Object)console, (String)"console");
        Project project = this.getSession().getProject();
        RunProfile runProfile = this.getSession().getRunProfile();
        if (!(runProfile instanceof CommonProgramRunConfigurationParameters)) {
            runProfile = null;
        }
        CommonProgramRunConfigurationParameters commonProgramRunConfigurationParameters = (CommonProgramRunConfigurationParameters)runProfile;
        console.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(project, commonProgramRunConfigurationParameters != null ? commonProgramRunConfigurationParameters.getWorkingDirectory() : null));
        console.addMessageFilter((Filter)new UrlFilter());
    }

    public NodeJsDebugProcessBase(@NotNull XDebugSession session2, @NotNull VmConnection<Vm> connection, @NotNull DebuggableFileFinder fileFinder, boolean isBreakOnFirstLine, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)fileFinder, (String)"fileFinder");
        super(session2, fileFinder, connection, executionResult);
        this.isBreakOnFirstLine = isBreakOnFirstLine;
        this.isFilesOnlyInLocalFileSystem = true;
    }

    public /* synthetic */ NodeJsDebugProcessBase(XDebugSession xDebugSession, VmConnection vmConnection, DebuggableFileFinder debuggableFileFinder, boolean bl, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            executionResult = null;
        }
        this(xDebugSession, (VmConnection<Vm>)vmConnection, debuggableFileFinder, bl, executionResult);
    }

    public static final /* synthetic */ void access$findSourceMap(NodeJsDebugProcessBase $this, @NotNull Vm vm, @NotNull Script script) {
        $this.findSourceMap(vm, script);
    }
}

