/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.nwjs.ForcedWipRemoteConnection;
import com.jetbrains.nwjs.RetryingWipRemoteConnection;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004H\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/nwjs/NwjsRemoteVmConnection;", "Lcom/jetbrains/debugger/wip/WipRemoteVmConnection;", "()V", "secondVmConnection", "Lorg/jetbrains/concurrency/AsyncPromise;", "getSecondVmConnection", "()Lorg/jetbrains/concurrency/AsyncPromise;", "processPageConnections", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "pageConnections", "", "Lcom/jetbrains/debugger/wip/PageConnection;", "result", "Lorg/jetbrains/debugger/Vm;", "ChromeConnector"})
public final class NwjsRemoteVmConnection
extends WipRemoteVmConnection {
    @NotNull
    private final AsyncPromise<WipRemoteVmConnection> secondVmConnection = new AsyncPromise();

    @NotNull
    public final AsyncPromise<WipRemoteVmConnection> getSecondVmConnection() {
        return this.secondVmConnection;
    }

    @Override
    protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<Vm> result) {
        WipRemoteVmConnection wipRemoteVmConnection;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(pageConnections, (String)"pageConnections");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        String url1 = null;
        String webSocketDebuggerUrl1 = null;
        String url2 = null;
        String webSocketDebuggerUrl2 = null;
        for (PageConnection p : pageConnections) {
            if (Intrinsics.areEqual((Object)p.getType(), (Object)"background_page")) {
                url2 = url1;
                webSocketDebuggerUrl2 = webSocketDebuggerUrl1;
                url1 = p.getUrl();
                webSocketDebuggerUrl1 = p.getWebSocketDebuggerUrl();
                continue;
            }
            if (url1 == null) {
                url1 = p.getUrl();
                webSocketDebuggerUrl1 = p.getWebSocketDebuggerUrl();
                continue;
            }
            if (url2 != null) continue;
            url2 = p.getUrl();
            webSocketDebuggerUrl2 = p.getWebSocketDebuggerUrl();
        }
        if (url1 == null && url2 == null) {
            result.setError("Bad response");
        }
        String string = url1;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = webSocketDebuggerUrl1;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        this.connectDebugger(string, string2, context, result, debugMessageQueue, false);
        if (url2 != null) {
            String string3 = webSocketDebuggerUrl2;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            wipRemoteVmConnection = new ForcedWipRemoteConnection(url2, string3);
        } else {
            wipRemoteVmConnection = new RetryingWipRemoteConnection(url1);
        }
        WipRemoteVmConnection secondConnection = wipRemoteVmConnection;
        this.secondVmConnection.setResult((Object)secondConnection);
        InetSocketAddress inetSocketAddress = this.getAddress();
        if (inetSocketAddress == null) {
            Intrinsics.throwNpe();
        }
        RemoteVmConnection.open$default((RemoteVmConnection)secondConnection, (InetSocketAddress)inetSocketAddress, null, (int)2, null);
        return false;
    }

    public NwjsRemoteVmConnection() {
        super(null, null, 3, null);
    }
}

