/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.AsynchronousAction;
import org.jetbrains.annotations.NonNls;

public class MergeAction
extends AsynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Merge file...";
    @NonNls
    private static final String VERSION_SIG = "version \"";
    @NonNls
    private static final String ERROR_TEXT = "<findmerge> can not find a version for merging in the VOB.";
    @NonNls
    private static final String ERROR_TITLE = "Merge Failed";

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }

    @Override
    public void perform(VirtualFile file, Project project) {
        String path = file.getPath().replace('/', File.separatorChar);
        String findVerOut = TransparentVcs.cleartoolWithOutput("findmerge", path, "-flatest", "-print", "-long");
        if (StringUtil.isNotEmpty((String)findVerOut)) {
            String elementVersion = MergeAction.extractVersion(findVerOut);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                TransparentVcs.cleartoolWithOutput("merge", "-g", "-to", path, elementVersion);
                file.putUserData(TransparentVcs.MERGE_CONFLICT, null);
                file.refresh(false, false);
                VcsUtil.markFileAsDirty((Project)project, (VirtualFile)file);
            });
        } else {
            AbstractVcsHelper.getInstance((Project)project).showError(new VcsException(ERROR_TEXT), ERROR_TITLE);
        }
    }

    @Override
    protected boolean isEnabled(VirtualFile file, Project project) {
        FileStatus status = MergeAction.getFileStatus(project, file);
        return status == FileStatus.MERGED_WITH_CONFLICTS;
    }

    private static String extractVersion(String findVerOut) {
        String[] lines;
        String version = "";
        for (String line : lines = LineTokenizer.tokenize((CharSequence)findVerOut, (boolean)false)) {
            if (!line.startsWith(VERSION_SIG)) continue;
            version = line.substring(VERSION_SIG.length(), line.length() - 1);
            break;
        }
        return version;
    }
}

