/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.transparent.CCaseConfig;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.ChangeManagement.CCaseChangeProvider;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.SynchronousAction;
import org.jetbrains.annotations.NonNls;

public class SynchActivitiesAction
extends SynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Synchronize Activities";

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Project project = SynchActivitiesAction.getEventProject((AnActionEvent)e);
        boolean enabled = project != null && CCaseViewsManager.getInstance(project).isAnyUcmView() && !CCaseConfig.getInstance((Project)project).synchActivitiesOnRefresh;
        e.getPresentation().setEnabled(enabled);
    }

    @Override
    protected void execute(AnActionEvent e, List<VcsException> errors) {
        try {
            this.perform(null, (Project)e.getData(CommonDataKeys.PROJECT));
        }
        catch (VcsException exc) {
            errors.add(exc);
        }
    }

    @Override
    protected void perform(VirtualFile file, Project project) throws VcsException {
        CCaseViewsManager.getInstance(project).extractViewActivities();
        CCaseViewsManager.getInstance(project).synchActivities2ChangeLists(null);
        SynchActivitiesAction.deleteObsoleteChangeLists(project);
        SynchActivitiesAction.relocateChangedFiles(project, TransparentVcs.getInstance(project));
        SynchActivitiesAction.relocateNewFiles(project);
    }

    private static void deleteObsoleteChangeLists(Project project) {
        CCaseViewsManager viewsMgr = CCaseViewsManager.getInstance(project);
        ChangeListManager changesMgr = ChangeListManager.getInstance((Project)project);
        List list = changesMgr.getChangeLists();
        for (LocalChangeList changeList : list) {
            CCaseViewsManager.ActivityInfo info = viewsMgr.getActivityForName(changeList.getName());
            if (info == null || !info.isObsolete) continue;
            changesMgr.removeChangeList(changeList.getName());
        }
    }

    private static void relocateChangedFiles(Project project, TransparentVcs host) {
        CCaseViewsManager viewsManager = CCaseViewsManager.getInstance(project);
        ChangeListManager mgr = ChangeListManager.getInstance((Project)project);
        List files = mgr.getAffectedFiles();
        ArrayList<String> files2Analyze = new ArrayList<String>();
        for (VirtualFile vfile : files) {
            if (mgr.getStatus(vfile) != FileStatus.MODIFIED || !host.fileIsUnderVcs(vfile.getPath())) continue;
            files2Analyze.add(vfile.getPath());
        }
        CCaseChangeProvider changeProvider = (CCaseChangeProvider)host.getChangeProvider();
        assert (changeProvider != null);
        changeProvider.setActivityInfoOnChangedFiles(files2Analyze);
        for (VirtualFile vfile : files) {
            if (mgr.getStatus(vfile) != FileStatus.MODIFIED || !host.fileIsUnderVcs(vfile.getPath())) continue;
            Change change = mgr.getChange(vfile);
            LocalChangeList list = mgr.getChangeList(change);
            String hostedActivity = viewsManager.getCheckoutActivityForFile(vfile.getPath());
            if (hostedActivity == null || hostedActivity.equals(list.getName())) continue;
            mgr.moveChangesTo(mgr.findChangeList(hostedActivity), new Change[]{change});
        }
    }

    private static void relocateNewFiles(Project project) {
        ChangeListManager changesMgr = ChangeListManager.getInstance((Project)project);
        ProjectLevelVcsManager pmgr = ProjectLevelVcsManager.getInstance((Project)project);
        CCaseViewsManager viewsManager = CCaseViewsManager.getInstance(project);
        List files = changesMgr.getAffectedFiles();
        for (VirtualFile vfile : files) {
            String currentActivityName;
            FileStatus status = changesMgr.getStatus(vfile);
            if (status != FileStatus.ADDED) continue;
            VirtualFile root = pmgr.getVcsRootFor(vfile);
            CCaseViewsManager.ViewInfo info = viewsManager.getViewByRoot(root);
            String string = currentActivityName = info.currentActivity != null ? info.currentActivity.publicName : null;
            if (info == null) continue;
            Change change = changesMgr.getChange(vfile);
            LocalChangeList list = changesMgr.getChangeList(change);
            if (currentActivityName == null || list.getName().equals(currentActivityName)) continue;
            viewsManager.addFile2Changelist(vfile.getPath(), currentActivityName);
            changesMgr.moveChangesTo(changesMgr.findChangeList(currentActivityName), new Change[]{change});
        }
    }

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }
}

