/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;

public class SpringProblemFileHighlightFilter
implements Condition<VirtualFile> {
    private final Project project;

    public SpringProblemFileHighlightFilter(Project project) {
        this.project = project;
    }

    public boolean value(VirtualFile virtualFile) {
        if (virtualFile.getFileType() != StdFileTypes.XML) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.project);
        if (module == null) {
            return false;
        }
        if (SpringFacet.getInstance((Module)module) == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
            return psiFile != null && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile));
        });
    }
}

