/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.importer;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=1000)
public class SpringExternalSystemDataService
extends AbstractProjectDataService<LibraryDependencyData, Module> {
    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/importer/SpringExternalSystemDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryDependencyData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/spring/facet/importer/SpringExternalSystemDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/importer/SpringExternalSystemDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/spring/facet/importer/SpringExternalSystemDataService", "importData"));
        }
        for (DataNode<LibraryDependencyData> node : toImport) {
            Module module;
            Set paths;
            String path;
            String externalName = ((LibraryDependencyData)node.getData()).getExternalName();
            if (!externalName.startsWith("org.springframework:spring-context:") || (path = (String)ContainerUtil.getFirstItem((Collection)(paths = ((LibraryData)((LibraryDependencyData)node.getData()).getTarget()).getPaths(LibraryPathType.BINARY)))) == null || (module = modelsProvider.findIdeModule(((LibraryDependencyData)node.getData()).getOwnerModule())) == null) continue;
            SpringExternalSystemDataService.setupSpringFacet(module, modelsProvider, ((LibraryDependencyData)node.getData()).getOwner());
        }
    }

    private static void setupSpringFacet(Module module, IdeModifiableModelsProvider modelsProvider, ProjectSystemId externalSystemId) {
        FacetType facetType = SpringFacet.getSpringFacetType();
        ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
        SpringFacet existing = (SpringFacet)facetModel.getFacetByType(facetType.getId());
        if (existing != null) {
            return;
        }
        SpringFacet facet = (SpringFacet)facetType.createFacet(module, facetType.getDefaultFacetName(), facetType.createDefaultConfiguration(), null);
        facetModel.addFacet((Facet)facet, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)externalSystemId));
    }
}

