/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringConfigurationTabSettings;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.nodes.AbstractFilesetNode;
import com.intellij.spring.facet.nodes.CodeGroupNode;
import com.intellij.spring.facet.nodes.ConfigFileNode;
import com.intellij.spring.facet.nodes.DependencyNode;
import com.intellij.spring.facet.nodes.FilesetGroupNode;
import com.intellij.spring.facet.nodes.PropertiesGroupNode;
import com.intellij.spring.facet.nodes.XmlGroupNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileSetNode
extends AbstractFilesetNode {
    static Comparator<ConfigFileNode> FILENAME_COMPARATOR = new FilenameComparator();

    public FileSetNode(@NotNull SpringFileSet fileSet, @NotNull SpringConfigurationTabSettings settings, @NotNull SimpleNode parent) {
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/facet/nodes/FileSetNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/spring/facet/nodes/FileSetNode", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/spring/facet/nodes/FileSetNode", "<init>"));
        }
        super(fileSet, settings, parent);
    }

    public SimpleNode[] getChildren() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        SpringFileSet fileSet = this.getFileSet();
        SpringConfigurationTabSettings settings = this.getConfigurationTabSettings();
        Set dependencyFileSets = fileSet.getDependencyFileSets();
        for (SpringFileSet dependencyFileSet : dependencyFileSets) {
            nodes.add((Object)new DependencyNode(dependencyFileSet, settings, this, this.getFileSet().getFacet().getModule()));
        }
        HashSet allCustomGroupFiles = new HashSet();
        SmartList customConfigFileGroups = new SmartList();
        for (SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
            if (!customization.isApplicable(fileSet)) continue;
            List groups = customization.getCustomConfigFileGroups(fileSet);
            customConfigFileGroups.addAll(groups);
            for (SpringFileSetEditorCustomization.CustomConfigFileGroup group : groups) {
                allCustomGroupFiles.addAll(group.getFiles());
            }
        }
        Set xmlFiles = fileSet.getXmlFiles();
        xmlFiles.removeAll(allCustomGroupFiles);
        Set codeFiles = fileSet.getCodeConfigurationFiles();
        codeFiles.removeAll(allCustomGroupFiles);
        if (!xmlFiles.isEmpty() && !codeFiles.isEmpty()) {
            nodes.add((Object)new XmlGroupNode(this, xmlFiles));
            nodes.add((Object)new CodeGroupNode(this, codeFiles));
        } else {
            ArrayList<ConfigFileNode> oneKindOfConfigFiles = new ArrayList<ConfigFileNode>();
            for (VirtualFilePointer file : xmlFiles) {
                oneKindOfConfigFiles.add(new ConfigFileNode(settings, fileSet, file, this));
            }
            for (VirtualFilePointer file : codeFiles) {
                oneKindOfConfigFiles.add(new ConfigFileNode(settings, fileSet, file, this));
            }
            if (settings.isSortAlpha()) {
                Collections.sort(oneKindOfConfigFiles, FILENAME_COMPARATOR);
            }
            nodes.addAll(oneKindOfConfigFiles);
        }
        Set propertiesFiles = fileSet.getPropertiesFiles();
        propertiesFiles.removeAll(allCustomGroupFiles);
        if (!propertiesFiles.isEmpty()) {
            nodes.add((Object)new PropertiesGroupNode(this, propertiesFiles));
        }
        for (final SpringFileSetEditorCustomization.CustomConfigFileGroup group : customConfigFileGroups) {
            nodes.add((Object)new FilesetGroupNode(this, group.getFiles()){

                @Override
                protected String getGroupName() {
                    return group.getName();
                }

                @Override
                protected Icon getGroupNodeIcon() {
                    return group.getIcon();
                }
            });
        }
        HashSet otherFiles = new HashSet(fileSet.getFiles());
        otherFiles.removeAll(xmlFiles);
        otherFiles.removeAll(codeFiles);
        otherFiles.removeAll(propertiesFiles);
        otherFiles.removeAll(allCustomGroupFiles);
        if (!otherFiles.isEmpty()) {
            nodes.add((Object)new FilesetGroupNode(this, otherFiles){

                @Override
                protected String getGroupName() {
                    return "Other Files";
                }

                @Override
                protected Icon getGroupNodeIcon() {
                    return AllIcons.FileTypes.Any_type;
                }
            });
        }
        return nodes.toArray(new SimpleNode[nodes.size()]);
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.clearText();
        SpringFileSet fileSet = this.getFileSet();
        presentation.addText(fileSet.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (fileSet.isAutodetected()) {
            presentation.addText(" " + SpringBundle.message("facet.context.autodetected.suffix", new Object[0]), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        presentation.setIcon(fileSet.getIcon());
    }

    private static class FilenameComparator
    implements Comparator<ConfigFileNode> {
        private FilenameComparator() {
        }

        @Override
        public int compare(ConfigFileNode o1, ConfigFileNode o2) {
            return StringUtil.naturalCompare((String)o1.getFilePointer().getFileName(), (String)o2.getFilePointer().getFileName());
        }
    }
}

