/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.aop.framework.ProxyFactoryBean";
    @NonNls
    private static final String PROXY_INTERFACES_PROPERTY_NAME = "proxyInterfaces";
    @NonNls
    private static final String INTERFACES_PROPERTY_NAME = "interfaces";
    @NonNls
    private static final String AUTODETECT_INTERFACES_PROPERTY_NAME = "autodetectInterfaces";
    @NonNls
    private static final String TARGET_PROPERTY_NAME = "target";
    @NonNls
    private static final String TARGET_NAME_PROPERTY_NAME = "targetName";
    @NonNls
    private static final String TARGET_CLASS_PROPERTY_NAME = "targetClass";

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        if (context instanceof SpringBean) {
            SpringBean springBean = (SpringBean)context;
            PsiType type = ProxyFactoryBeanTypeResolver.getTargetType(springBean);
            if (type != null && ProxyFactoryBeanTypeResolver.isCglibExplicitlyEnabled(springBean)) {
                Set<String> set = Collections.singleton(type.getCanonicalText());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
            Set<String> proxyInterfaceNames = ProxyFactoryBeanTypeResolver.getTypesFromClassArrayProperty(springBean, PROXY_INTERFACES_PROPERTY_NAME);
            if (!proxyInterfaceNames.isEmpty()) {
                Set<String> set = proxyInterfaceNames;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
            Set<String> interfaceNames = ProxyFactoryBeanTypeResolver.getTypesFromClassArrayProperty(springBean, INTERFACES_PROPERTY_NAME);
            if (!interfaceNames.isEmpty()) {
                Set<String> set = interfaceNames;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
            if (type != null) {
                Set<String> targetInterfaceNames = ProxyFactoryBeanTypeResolver.getAllInterfaceNames(type);
                if (!targetInterfaceNames.isEmpty() && ProxyFactoryBeanTypeResolver.isAutodetectInterfacesEnabled(springBean)) {
                    Set<String> set = targetInterfaceNames;
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "getObjectType"));
                    }
                    return set;
                }
                Set<String> set = Collections.singleton(type.getCanonicalText());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Nullable
    private static PsiType getTargetType(@NotNull SpringBean context) {
        PsiClassType fromTargetName;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "getTargetType"));
        }
        PsiType fromTarget = ProxyFactoryBeanTypeResolver.getTypeFromProperty(context, TARGET_PROPERTY_NAME);
        if (fromTarget != null) {
            return fromTarget;
        }
        String targetName = ProxyFactoryBeanTypeResolver.getPropertyValue((CommonSpringBean)context, TARGET_NAME_PROPERTY_NAME);
        if (targetName != null && (fromTargetName = ProxyFactoryBeanTypeResolver.getTypeFromBeanName(context, targetName)) != null) {
            return fromTargetName;
        }
        String targetClassName = ProxyFactoryBeanTypeResolver.getPropertyValue((CommonSpringBean)context, TARGET_CLASS_PROPERTY_NAME);
        if (targetClassName != null) {
            Project project = context.getManager().getProject();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClass targetClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(targetClassName, scope);
            if (targetClass != null) {
                return PsiTypesUtil.getClassType((PsiClass)targetClass);
            }
        }
        return null;
    }

    private static boolean isAutodetectInterfacesEnabled(@NotNull SpringBean context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "isAutodetectInterfacesEnabled"));
        }
        return !ProxyFactoryBeanTypeResolver.isBooleanPropertySetAndFalse(context, AUTODETECT_INTERFACES_PROPERTY_NAME);
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/ProxyFactoryBeanTypeResolver", "accept"));
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }
}

