/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDomAnnotator
extends LineMarkerProviderDescriptor {
    private static final NotNullFunction<CommonSpringBean, Collection<? extends PsiElement>> STEREOTYPES_CONVERTER = commonSpringBean -> Collections.singleton(commonSpringBean.getIdentifyingPsiElement());
    private static final NotNullFunction<SpringBeanPointer, Collection<? extends PsiElement>> CONVERTER = pointer -> {
        CommonSpringBean springBean = pointer.getSpringBean();
        if (springBean instanceof DomSpringBean) {
            return ContainerUtil.createMaybeSingletonList((Object)((DomSpringBean)springBean).getXmlElement());
        }
        return ContainerUtil.createMaybeSingletonList((Object)pointer.getPsiElement());
    };
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;

    public SpringDomAnnotator(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/gutter/SpringDomAnnotator", "getLineMarkerInfo"));
        }
        if (!this.myDaemonSettings.SHOW_METHOD_SEPARATORS) {
            return null;
        }
        if (!(psiElement instanceof XmlTag)) {
            return null;
        }
        if (!SpringDomAnnotator.isSpringXml(psiElement.getContainingFile())) {
            return null;
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)psiElement);
        if (!(domElement instanceof Beans)) {
            return null;
        }
        if (domElement.equals(DomUtil.getFileElement((DomElement)domElement).getRootElement())) {
            return null;
        }
        return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)domElement.getXmlTag(), (EditorColorsManager)this.myColorsManager);
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/spring/gutter/SpringDomAnnotator", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/gutter/SpringDomAnnotator", "collectSlowLineMarkers"));
        }
        if (elements.isEmpty()) {
            return;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (!SpringDomAnnotator.isSpringXml(file)) {
            return;
        }
        SpringModel model = SpringManager.getInstance((Project)file.getProject()).getSpringModelByFile(file);
        if (model == null) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ProgressManager.checkCanceled();
            PsiElement element = elements.get(i);
            SpringDomAnnotator.annotate(model, element, result);
        }
    }

    public String getId() {
        return "SpringDomAnnotator";
    }

    @NotNull
    public String getName() {
        if ("Configuration (XML)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "getName"));
        }
        return "Configuration (XML)";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.SpringConfig;
    }

    private static boolean isSpringXml(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        return SpringDomUtils.isSpringXml((XmlFile)xmlFile);
    }

    private static void annotateSpringBeanChildren(final SpringModel model, SpringBean bean, Collection<LineMarkerInfo> result) {
        XmlTag tag = bean.getXmlTag();
        if (tag == null) {
            return;
        }
        final SpringBeanPointer pointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean);
        if (SpringDomAnnotator.getChildren(model, pointer).isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.ParentBeanGutter, CONVERTER).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

            @NotNull
            protected Collection<? extends SpringBeanPointer> compute() {
                SmartList children = new SmartList();
                children.addAll(SpringDomAnnotator.getChildren(model, pointer));
                Collections.sort(children, SpringBeanPointer.DISPLAY_COMPARATOR);
                SmartList smartList = children;
                if (smartList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator$1", "compute"));
                }
                return smartList;
            }
        }).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.parent.bean.tooltip", new Object[0]));
        result.add((LineMarkerInfo)iconBuilder.createLineMarkerInfo((PsiElement)bean.getXmlTag()));
    }

    @NotNull
    private static List<SpringBeanPointer> getChildren(SpringModel model, @NotNull SpringBeanPointer parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/spring/gutter/SpringDomAnnotator", "getChildren"));
        }
        List list = model.getDescendants(parent);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "getChildren"));
        }
        return list;
    }

    private static void annotate(SpringModel model, @NotNull PsiElement psiElement, Collection<LineMarkerInfo> result) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/gutter/SpringDomAnnotator", "annotate"));
        }
        if (psiElement instanceof XmlTag) {
            DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement((XmlTag)psiElement);
            if (element instanceof SpringBean) {
                SpringDomAnnotator.annotateSpringBeanChildren(model, (SpringBean)element, result);
                SpringDomAnnotator.annotateAutowiredBeans(model, (SpringBean)element, result);
            } else if (element instanceof SpringBeansPackagesScanBean) {
                SpringDomAnnotator.annotateComponentScan((SpringBeansPackagesScanBean)element, result);
            }
        }
    }

    private static void annotateComponentScan(final @NotNull SpringBeansPackagesScanBean componentScan, @NotNull Collection<LineMarkerInfo> result) {
        if (componentScan == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentScan", "com/intellij/spring/gutter/SpringDomAnnotator", "annotateComponentScan"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/gutter/SpringDomAnnotator", "annotateComponentScan"));
        }
        XmlTag tag = componentScan.getXmlTag();
        if (tag == null) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.SpringScan, STEREOTYPES_CONVERTER).setPopupTitle(SpringBundle.message("spring.dom.component.scan.stereotypes", new Object[0])).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setTooltipText(SpringBundle.message("spring.dom.component.scan.stereotypes.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends CommonSpringBean>>(){

            @NotNull
            protected Collection<? extends CommonSpringBean> compute() {
                SortedList sortedList = SpringDomAnnotator.getSortedByName(SpringDomAnnotator.getScannedStereotypesFromAllModels(componentScan));
                if (sortedList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator$2", "compute"));
                }
                return sortedList;
            }
        });
        result.add((LineMarkerInfo)builder.createLineMarkerInfo((PsiElement)tag));
    }

    @NotNull
    private static Set<CommonSpringBean> getScannedStereotypesFromAllModels(@NotNull SpringBeansPackagesScanBean componentScan) {
        if (componentScan == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentScan", "com/intellij/spring/gutter/SpringDomAnnotator", "getScannedStereotypesFromAllModels"));
        }
        XmlTag tag = componentScan.getXmlTag();
        Module module = componentScan.getModule();
        if (tag == null || module == null) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "getScannedStereotypesFromAllModels"));
            }
            return set;
        }
        XmlFile xmlFile = DomUtil.getFile((DomElement)componentScan);
        LinkedHashSet stereotypeElements = ContainerUtil.newLinkedHashSet();
        Set models = SpringManager.getInstance((Project)xmlFile.getProject()).getSpringModelsByFile((PsiFile)xmlFile);
        for (CommonSpringModel springModel : models) {
            Set scannedElements;
            Module springModelModule = springModel.getModule();
            if (springModelModule == null || (scannedElements = componentScan.getScannedElements(springModelModule)).isEmpty()) continue;
            ArrayList elements = new ArrayList(scannedElements);
            stereotypeElements.addAll(SpringProfileUtils.filterBeansInActiveProfiles((Collection)new SmartList(elements), (Set)springModel.getActiveProfiles()));
        }
        LinkedHashSet linkedHashSet = stereotypeElements;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "getScannedStereotypesFromAllModels"));
        }
        return linkedHashSet;
    }

    private static SortedList<CommonSpringBean> getSortedByName(Set<CommonSpringBean> stereotypeElements) {
        SortedList sortedList = new SortedList((o1, o2) -> {
            String beanName1 = o1.getBeanName();
            String beanName2 = o2.getBeanName();
            if (beanName1 != null && beanName2 != null) {
                return beanName1.compareTo(beanName2);
            }
            return 0;
        });
        sortedList.addAll(stereotypeElements);
        return sortedList;
    }

    private static void annotateAutowiredBeans(SpringModel model, @NotNull SpringBean springBean, @NotNull Collection<LineMarkerInfo> result) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/gutter/SpringDomAnnotator", "annotateAutowiredBeans"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/gutter/SpringDomAnnotator", "annotateAutowiredBeans"));
        }
        XmlTag tag = springBean.getXmlTag();
        if (tag == null) {
            return;
        }
        Collection<SpringBeanPointer> autowiredBeans = SpringDomAnnotator.getAutowiredBeans(model, springBean);
        if (!autowiredBeans.isEmpty()) {
            NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(autowiredBeans, result, (PsiElement)tag);
        }
    }

    @NotNull
    private static Collection<SpringBeanPointer> getAutowiredBeans(SpringModel model, SpringBean springBean) {
        if (SpringAutowireUtil.isByTypeAutowired(springBean)) {
            Set<SpringBeanPointer> set = SpringDomAnnotator.collectAllPointers(SpringAutowireUtil.getByTypeAutowiredProperties(springBean, (CommonSpringModel)model).values());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "getAutowiredBeans"));
            }
            return set;
        }
        if (SpringAutowireUtil.isByNameAutowired(springBean)) {
            Collection<SpringBeanPointer> collection = SpringAutowireUtil.getByNameAutowiredProperties(springBean).values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "getAutowiredBeans"));
            }
            return collection;
        }
        if (SpringAutowireUtil.isConstructorAutowire(springBean)) {
            Set<SpringBeanPointer> set = SpringDomAnnotator.collectAllPointers(SpringAutowireUtil.getConstructorAutowiredProperties(springBean, (CommonSpringModel)model).values());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "getAutowiredBeans"));
            }
            return set;
        }
        Set<SpringBeanPointer> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "getAutowiredBeans"));
        }
        return set;
    }

    @NotNull
    private static Set<SpringBeanPointer> collectAllPointers(@NotNull Collection<Collection<SpringBeanPointer>> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/spring/gutter/SpringDomAnnotator", "collectAllPointers"));
        }
        LinkedHashSet beanPointers = ContainerUtil.newLinkedHashSet();
        for (Collection<SpringBeanPointer> pointers : values) {
            beanPointers.addAll(pointers);
        }
        LinkedHashSet linkedHashSet = beanPointers;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDomAnnotator", "collectAllPointers"));
        }
        return linkedHashSet;
    }
}

