/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBeanFactoryAwareTypeProvider
extends SpringBeanEffectiveTypeProvider {
    public void processEffectiveTypes(@NotNull CommonSpringBean bean, Collection<PsiType> result) {
        PsiClass aClass;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/SpringBeanFactoryAwareTypeProvider", "processEffectiveTypes"));
        }
        PsiType beanType = bean.getBeanType();
        if (beanType instanceof PsiClassType && (aClass = ((PsiClassType)beanType).resolve()) != null && SpringBeanFactoryAwareTypeProvider.isBeanFactoryAwareClass(aClass)) {
            ContainerUtil.addAllNotNull(result, SpringBeanFactoryAwareTypeProvider.getBeanFactoryAwareTypes(aClass));
        }
    }

    private static Collection<PsiType> getBeanFactoryAwareTypes(@NotNull PsiClass psiClass) {
        PsiMethod[] resolvableDependencies;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/SpringBeanFactoryAwareTypeProvider", "getBeanFactoryAwareTypes"));
        }
        HashSet types = new HashSet();
        PsiClass factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("org.springframework.beans.factory.config.ConfigurableListableBeanFactory", psiClass.getResolveScope());
        if (factory != null && (resolvableDependencies = factory.findMethodsByName("registerResolvableDependency", false)).length > 0) {
            PsiMethod registerMethod = resolvableDependencies[0];
            PsiMethod[] setBeanFactoryMethods = psiClass.findMethodsByName("setBeanFactory", false);
            if (setBeanFactoryMethods.length > 0) {
                MethodReferencesSearch.search((PsiMethod)registerMethod, (SearchScope)new LocalSearchScope((PsiElement)setBeanFactoryMethods[0]), (boolean)true).forEach(arg_0 -> SpringBeanFactoryAwareTypeProvider.lambda$getBeanFactoryAwareTypes$0((Set)types, arg_0));
            }
        }
        return types;
    }

    private static boolean isBeanFactoryAwareClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/SpringBeanFactoryAwareTypeProvider", "isBeanFactoryAwareClass"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/SpringBeanFactoryAwareTypeProvider", "lambda$isBeanFactoryAwareClass$1"));
            }
            boolean isBeanFactory = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.BeanFactoryAware");
            return CachedValueProvider.Result.createSingleDependency((Object)isBeanFactory, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    private static /* synthetic */ void lambda$getBeanFactoryAwareTypes$0(Set types, PsiReference psiReference) {
        PsiClass genericClass;
        PsiType genericType;
        PsiExpression dependencyTypeExpression;
        PsiType expressionType;
        PsiExpression[] expressions;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
        if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length > 0 && (expressionType = (dependencyTypeExpression = expressions[0]).getType()) instanceof PsiClassType && (genericType = PsiUtil.substituteTypeParameter((PsiType)expressionType, (String)"java.lang.Class", (int)0, (boolean)true)) instanceof PsiClassType && (genericClass = ((PsiClassType)genericType).resolve()) != null) {
            types.add(PsiTypesUtil.getClassType((PsiClass)genericClass));
        }
    }
}

