/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringFactoryBeansEffectiveTypesProviders
extends SpringBeanEffectiveTypeProvider {
    public void processEffectiveTypes(@NotNull CommonSpringBean bean, Collection<PsiType> result) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/SpringFactoryBeansEffectiveTypesProviders", "processEffectiveTypes"));
        }
        PsiType beanType = bean.getBeanType();
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)beanType);
        if (beanClass == null) {
            return;
        }
        if (SpringFactoryBeansManager.getInstance().isFactoryBeanClass(beanClass)) {
            result.clear();
            ContainerUtil.addAllNotNull(result, SpringBeanCoreUtils.getFactoryBeanTypes(beanType, bean));
        }
    }
}

