/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.highlighting.DomSpringBeanInspectionBase;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.Props;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringMap;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.impl.ConvertContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionValueTypeInspection
extends DomSpringBeanInspectionBase {
    @NotNull
    @NonNls
    public String getShortName() {
        if ("InjectionValueTypeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "getShortName"));
        }
        return "InjectionValueTypeInspection";
    }

    private static void checkIdRef(SpringElementsHolder elementsHolder, DomElementAnnotationHolder holder, @NotNull List<PsiType> injectionTypes) {
        if (injectionTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectionTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkIdRef"));
        }
        if (DomUtil.hasXml((DomElement)elementsHolder.getIdref())) {
            InjectionValueTypeInspection.checkPropertyTypeByClass(elementsHolder, String.class, holder, injectionTypes, (DomElement)elementsHolder.getIdref());
        }
    }

    private static void checkSpringPropertyValueType(SpringElementsHolder elementsHolder, DomElementAnnotationHolder holder, @NotNull List<PsiType> propertyTypes) {
        if (propertyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkSpringPropertyValueType"));
        }
        SpringValue value = elementsHolder.getValue();
        if (!DomUtil.hasXml((DomElement)value)) {
            return;
        }
        GenericAttributeValue valueType = value.getType();
        PsiType type = (PsiType)valueType.getValue();
        if (type == null) {
            return;
        }
        if (!InjectionValueTypeInspection.isAssignableFrom(type, propertyTypes)) {
            String message = SpringBundle.message("bean.bad.property.type", InjectionValueTypeInspection.typesToString(propertyTypes), type.getCanonicalText());
            holder.createProblem((DomElement)elementsHolder.getValue().getType(), message, new LocalQuickFix[0]);
        }
    }

    private static String typesToString(@NotNull List<PsiType> propertyTypes) {
        if (propertyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "typesToString"));
        }
        NullableFunction function = psiType -> psiType == null ? null : psiType.getCanonicalText();
        return StringUtil.join(propertyTypes, (Function)function, (String)" or ");
    }

    private static boolean isAssignableFrom(@NotNull PsiType type, @NotNull List<? extends PsiType> propertyTypes) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "isAssignableFrom"));
        }
        if (propertyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "isAssignableFrom"));
        }
        for (PsiType psiType : propertyTypes) {
            if (psiType == null || !psiType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private void checkSpringPropertyListAndSet(SpringElementsHolder elementsHolder, DomElementAnnotationHolder holder, @Nullable List<PsiType> propertyType) {
        ListOrSet set = elementsHolder.getSet();
        ListOrSet list = elementsHolder.getList();
        ListOrSet array = elementsHolder.getArray();
        if (DomUtil.hasXml((DomElement)array)) {
            this.checkSpringPropertyCollection(array, holder);
        }
        if (DomUtil.hasXml((DomElement)set)) {
            this.checkSpringPropertyCollection(set, holder);
            if (propertyType != null) {
                InjectionValueTypeInspection.checkPropertyTypeByClass(elementsHolder, Set.class, holder, propertyType, (DomElement)set);
            }
        }
        if (DomUtil.hasXml((DomElement)list)) {
            this.checkSpringPropertyCollection(list, holder);
            if (propertyType != null) {
                InjectionValueTypeInspection.checkPropertyTypeByClass(elementsHolder, List.class, holder, propertyType, (DomElement)list);
            }
        }
    }

    private void checkSpringPropertyMap(SpringElementsHolder elementsHolder, DomElementAnnotationHolder holder, @NotNull List<PsiType> propertyTypes) {
        if (propertyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkSpringPropertyMap"));
        }
        SpringMap map = elementsHolder.getMap();
        if (DomUtil.hasXml((DomElement)map)) {
            InjectionValueTypeInspection.checkPropertyTypeByClass(elementsHolder, Map.class, holder, propertyTypes, (DomElement)map);
        }
        PsiClass keyClass = (PsiClass)map.getKeyType().getValue();
        PsiClass valueClass = (PsiClass)map.getValueType().getValue();
        for (PsiType propertyType : propertyTypes) {
            PsiType keyType = keyClass == null ? PsiUtil.substituteTypeParameter((PsiType)propertyType, (String)"java.util.Map", (int)0, (boolean)false) : JavaPsiFacade.getElementFactory((Project)keyClass.getProject()).createType(keyClass);
            PsiType valueType = valueClass == null ? PsiUtil.substituteTypeParameter((PsiType)propertyType, (String)"java.util.Map", (int)1, (boolean)false) : JavaPsiFacade.getElementFactory((Project)valueClass.getProject()).createType(valueClass);
            List entries = map.getEntries();
            for (SpringEntry entry : entries) {
                GenericAttributeValue keyRef = entry.getKeyRef();
                GenericAttributeValue valueRef = entry.getValueRef();
                if (valueType != null && DomUtil.hasXml((DomElement)valueRef)) {
                    this.checkBeanClass((SpringBeanPointer)valueRef.getValue(), Collections.singletonList(valueType), (DomElement)valueRef, holder);
                }
                if (keyType == null || !DomUtil.hasXml((DomElement)keyRef)) continue;
                this.checkBeanClass((SpringBeanPointer)keyRef.getValue(), Collections.singletonList(keyType), (DomElement)keyRef, holder);
            }
        }
    }

    private static void checkSpringPropertyProps(SpringElementsHolder property, DomElementAnnotationHolder holder, @NotNull List<PsiType> propertyType) {
        if (propertyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyType", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkSpringPropertyProps"));
        }
        Props props = property.getProps();
        if (DomUtil.hasXml((DomElement)props)) {
            InjectionValueTypeInspection.checkPropertyTypeByClass(property, Properties.class, holder, propertyType, (DomElement)props);
        }
    }

    public void checkSpringPropertyCollection(ListOrSet collection, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)collection)) {
            return;
        }
        PsiType psiClass = TypeHolderUtil.getRequiredType((TypeHolder)collection);
        if (psiClass != null) {
            this.checkCollectionElementsType(psiClass, (CollectionElements)collection, holder);
        }
        for (ListOrSet listOrSet : collection.getLists()) {
            this.checkSpringPropertyCollection(listOrSet, holder);
        }
    }

    private void checkCollectionElementsType(@NotNull PsiType type, CollectionElements collection, DomElementAnnotationHolder holder) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkCollectionElementsType"));
        }
        for (SpringRef ref : collection.getRefs()) {
            this.checkSpringRefType(ref, Collections.singletonList(type), holder);
        }
        for (Idref idref : collection.getIdrefs()) {
            if ("java.lang.String".equals(type.getCanonicalText())) continue;
            holder.createProblem((DomElement)idref, SpringBundle.message("idref.cannot.be.added.in.collection", type.getCanonicalText()), new LocalQuickFix[0]);
        }
        if (type instanceof PsiClassType) {
            for (SpringBean springBean : collection.getBeans()) {
                this.checkBeanClass((CommonSpringBean)springBean, Collections.singletonList(type), (DomElement)springBean, holder);
            }
        }
    }

    private void checkSpringInjectionRefAttr(DomElementAnnotationHolder holder, @Nullable List<PsiType> propertyType, @Nullable GenericDomValue<SpringBeanPointer> refAttr) {
        if (propertyType == null || refAttr == null || !DomUtil.hasXml(refAttr)) {
            return;
        }
        SpringBeanPointer beanPointer = (SpringBeanPointer)refAttr.getValue();
        if (beanPointer != null) {
            this.checkBeanClass(beanPointer, propertyType, (DomElement)refAttr, holder);
        }
    }

    private void checkSpringRefType(SpringRef ref, List<PsiType> psiTypes, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)ref)) {
            return;
        }
        this.checkBeanClass((SpringBeanPointer)ref.getBean().getValue(), psiTypes, (DomElement)ref.getBean(), holder);
        this.checkBeanClass((SpringBeanPointer)ref.getLocal().getValue(), psiTypes, (DomElement)ref.getLocal(), holder);
        this.checkBeanClass((SpringBeanPointer)ref.getParentAttr().getValue(), psiTypes, (DomElement)ref.getParentAttr(), holder);
    }

    private void checkSpringPropertyInnerBean(SpringElementsHolder elementsHolder, DomElementAnnotationHolder holder, @NotNull List<PsiType> injectionTypes) {
        if (injectionTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectionTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkSpringPropertyInnerBean"));
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        SpringBeanUtils.getInstance().processChildBeans((DomElement)elementsHolder, false, (Processor)processor);
        if (processor.isFound()) {
            CommonSpringBean bean = (CommonSpringBean)processor.getFoundValue();
            DomSpringBean springBean = bean instanceof CustomBean ? ((CustomBean)bean).getWrapper() : (DomSpringBean)bean;
            this.checkBeanClass(bean, injectionTypes, (DomElement)springBean, holder);
        }
    }

    protected void checkBeanClass(@Nullable SpringBeanPointer springBeanPointer, @NotNull List<PsiType> psiTypes, DomElement annotatedElement, @NotNull DomElementAnnotationHolder holder) {
        if (psiTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkBeanClass"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkBeanClass"));
        }
        if (springBeanPointer != null && springBeanPointer.isValid()) {
            this.checkBeanClass(springBeanPointer.getSpringBean(), psiTypes, annotatedElement, holder);
        }
    }

    protected void checkBeanClass(@Nullable CommonSpringBean springBean, @NotNull List<PsiType> psiTypes, DomElement annotatedElement, @NotNull DomElementAnnotationHolder holder) {
        if (psiTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkBeanClass"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkBeanClass"));
        }
        if (springBean == null || !springBean.isValid()) {
            return;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass == null) {
            return;
        }
        if (!InjectionValueTypeInspection.processEffectiveClassTypes(springBean, psiTypes, annotatedElement, holder)) {
            InjectionValueTypeInspection.processSpringBeanResolveConverterRequiredTypes(springBean, annotatedElement, holder);
        }
    }

    private static void processSpringBeanResolveConverterRequiredTypes(CommonSpringBean springBean, DomElement annotatedElement, DomElementAnnotationHolder holder) {
        GenericDomValue genericDomValue;
        Converter converter;
        if (annotatedElement instanceof GenericDomValue && (converter = (genericDomValue = (GenericDomValue)annotatedElement).getConverter()) instanceof SpringBeanResolveConverter) {
            List requiredClasses = ((SpringBeanResolveConverter)converter).getRequiredClasses(ConvertContextFactory.createConvertContext((DomElement)genericDomValue));
            InjectionValueTypeInspection.processEffectiveClassTypes(springBean, requiredClasses, annotatedElement, holder);
        }
    }

    private static boolean processEffectiveClassTypes(@NotNull CommonSpringBean springBean, @NotNull List<? extends PsiType> psiTypes, @NotNull DomElement annotatedElement, @NotNull DomElementAnnotationHolder holder) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "processEffectiveClassTypes"));
        }
        if (psiTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "processEffectiveClassTypes"));
        }
        if (annotatedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotatedElement", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "processEffectiveClassTypes"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "processEffectiveClassTypes"));
        }
        if ((psiTypes = InjectionValueTypeInspection.convertToEffectiveTypes(psiTypes, annotatedElement.getManager().getProject())).size() != 0 && !SpringBeanCoreUtils.isEffectiveClassType(psiTypes, springBean)) {
            for (PsiType psiType : psiTypes) {
                if (!InjectionValueTypeInspection.tryCreatingCustomProblem(springBean, psiType, annotatedElement, holder)) continue;
                return true;
            }
            String key = psiTypes.size() == 1 ? "bean.must.be.of.type" : "bean.must.be.one.of.these.types";
            String string = SpringApiBundle.message((String)key, (Object[])new Object[]{InjectionValueTypeInspection.typesToString(new ArrayList<PsiType>(psiTypes))});
            holder.createProblem(annotatedElement, string, new LocalQuickFix[0]);
            return true;
        }
        return false;
    }

    @NotNull
    private static List<PsiType> convertToEffectiveTypes(List<? extends PsiType> psiTypes, Project project) {
        ArrayList<PsiType> types = new ArrayList<PsiType>(psiTypes.size());
        for (PsiType psiType : psiTypes) {
            if (psiType == null) continue;
            if (psiType instanceof PsiArrayType) {
                types.add(((PsiArrayType)psiType).getComponentType());
                InjectionValueTypeInspection.addCollectionType(types, project);
            } else if (PsiTypeUtil.getInstance((Project)project).isCollectionType(psiType)) {
                PsiType genericType = PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Collection", (int)0, (boolean)true);
                if (genericType != null) {
                    types.add(genericType);
                } else {
                    InjectionValueTypeInspection.addObjectType(types, project);
                }
            }
            types.add(psiType);
        }
        ArrayList<PsiType> arrayList = types;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "convertToEffectiveTypes"));
        }
        return arrayList;
    }

    private static void addObjectType(@NotNull List<PsiType> types, @NotNull Project project) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "addObjectType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "addObjectType"));
        }
        InjectionValueTypeInspection.addType(types, project, "java.lang.Object");
    }

    private static void addCollectionType(@NotNull List<PsiType> types, @NotNull Project project) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "addCollectionType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "addCollectionType"));
        }
        InjectionValueTypeInspection.addType(types, project, "java.util.Collection");
    }

    private static void addType(@NotNull List<PsiType> types, @NotNull Project project, @NotNull String fqn) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "addType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "addType"));
        }
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "addType"));
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        if (aClass != null) {
            types.add((PsiType)PsiTypesUtil.getClassType((PsiClass)aClass));
        }
    }

    private static boolean tryCreatingCustomProblem(CommonSpringBean springBean, PsiType psiType, DomElement annotatedElement, DomElementAnnotationHolder holder) {
        for (SpringBeanEffectiveTypeProvider provider : (SpringBeanEffectiveTypeProvider[])SpringBeanEffectiveTypeProvider.EP_NAME.getExtensions()) {
            if (!provider.createCustomProblem(springBean, psiType, holder, annotatedElement)) continue;
            return true;
        }
        return false;
    }

    private static void checkPropertyTypeByClass(SpringElementsHolder injection, Class requiredClass, DomElementAnnotationHolder holder, @NotNull List<PsiType> propertyTypes, DomElement value) {
        if (propertyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkPropertyTypeByClass"));
        }
        for (PsiType propertyType : propertyTypes) {
            if (propertyType == null || !requiredClass.getName().equals(propertyType.getCanonicalText())) continue;
            return;
        }
        Project project = injection.getManager().getProject();
        PsiType requiredType = PsiTypeUtil.getInstance((Project)project).findType(requiredClass);
        InjectionValueTypeInspection.checkPropertyType(holder, propertyTypes, value, project, requiredType);
    }

    private static void checkPropertyType(@NotNull DomElementAnnotationHolder holder, @NotNull List<PsiType> propertyTypes, @NotNull DomElement value, @NotNull Project project, @Nullable PsiType requiredType) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkPropertyType"));
        }
        if (propertyTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyTypes", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkPropertyType"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkPropertyType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/InjectionValueTypeInspection", "checkPropertyType"));
        }
        if (requiredType == null || propertyTypes.size() == 0) {
            return;
        }
        if (!InjectionValueTypeInspection.isAssignableFrom(requiredType, propertyTypes) && !PsiTypeUtil.getInstance((Project)project).isConvertable(requiredType, propertyTypes)) {
            String message = SpringBundle.message("bean.bad.property.type", InjectionValueTypeInspection.typesToString(propertyTypes), requiredType.getPresentableText());
            holder.createProblem(value, message, new LocalQuickFix[0]);
        }
    }

    @Override
    protected void checkBean(DomSpringBean springBean, Beans beans, DomElementAnnotationHolder holder, SpringModel springModel) {
        for (SpringValueHolderDefinition definition : SpringPropertyUtils.getValueHolders((CommonSpringBean)springBean)) {
            List propertyTypes = ContainerUtil.skipNulls((Collection)TypeHolderUtil.getRequiredTypes((TypeHolder)definition));
            this.checkSpringInjectionRefAttr(holder, propertyTypes, (GenericDomValue<SpringBeanPointer>)definition.getRefElement());
            if (!(definition instanceof SpringElementsHolder)) continue;
            this.checkElementsHolder((SpringElementsHolder)definition, propertyTypes, holder);
        }
    }

    private void checkElementsHolder(SpringElementsHolder elementsHolder, @Nullable List<PsiType> requiredTypes, DomElementAnnotationHolder holder) {
        if (requiredTypes != null && requiredTypes.size() > 0) {
            InjectionValueTypeInspection.checkSpringPropertyValueType(elementsHolder, holder, requiredTypes);
            InjectionValueTypeInspection.checkIdRef(elementsHolder, holder, requiredTypes);
            InjectionValueTypeInspection.checkSpringPropertyProps(elementsHolder, holder, requiredTypes);
            this.checkSpringPropertyMap(elementsHolder, holder, requiredTypes);
            this.checkSpringPropertyInnerBean(elementsHolder, holder, requiredTypes);
        }
        this.checkSpringPropertyListAndSet(elementsHolder, holder, requiredTypes);
    }
}

