/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.highlighting.dom.SpringDomInspectionUtils;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanAttributesInspection
extends SpringBeanInspectionBase {
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringBeanAttributesInspection", "checkBean"));
        }
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/SpringBeanAttributesInspection", "checkBean"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/SpringBeanAttributesInspection", "checkBean"));
        }
        SpringDomInspectionUtils utils = new SpringDomInspectionUtils(holder);
        if (!utils.onlyOneOf((DomElement)springBean, new GenericAttributeValue[]{springBean.getClazz(), springBean.getFactoryBean()})) {
            utils.ifExistsOtherRequired((DomElement)springBean, springBean.getFactoryBean(), springBean.getFactoryMethod());
        }
        utils.attributeWithDefaultSuperfluous(springBean.getAbstract(), (Object)Boolean.FALSE);
        utils.attributeWithDefaultSuperfluous(springBean.getSingleton(), (Object)Boolean.TRUE);
        utils.attributeWithDefaultSuperfluous(springBean.getScope(), (Object)SpringBeanScope.SINGLETON_SCOPE);
        if (springBean.getParent() instanceof SpringValueHolder) {
            utils.attributeSuperfluous(springBean.getId());
            utils.attributeSuperfluous(springBean.getName());
            utils.attributeSuperfluous(springBean.getScope());
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringBeanAttributesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringBeanAttributesInspection", "getShortName"));
        }
        return "SpringBeanAttributesInspection";
    }
}

