/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.imp;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.RepositoryPlugin;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.jetbrains.osgi.jps.model.OutputPathType;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetType;
import org.osmorc.i18n.OsmorcBundle;

public class BndProjectImporter {
    public static final String CNF_DIR = "cnf";
    public static final String BUILD_FILE = "build.bnd";
    public static final String BND_FILE = "bnd.bnd";
    public static final String BND_LIB_PREFIX = "bnd:";
    public static final NotificationGroup NOTIFICATIONS = new NotificationGroup("OSGi Bnd Notifications", NotificationDisplayType.STICKY_BALLOON, true);
    private static final Logger LOG = Logger.getInstance(BndProjectImporter.class);
    private static final Key<Workspace> BND_WORKSPACE_KEY = Key.create((String)"bnd.workspace.key");
    private static final String JAVAC_SOURCE = "javac.source";
    private static final String JAVAC_TARGET = "javac.target";
    private static final String SRC_ROOT = "OSGI-OPT/src";
    private static final String JDK_DEPENDENCY = "ee.j2se";
    private static final Comparator<OrderEntry> ORDER_ENTRY_COMPARATOR = new Comparator<OrderEntry>(){

        @Override
        public int compare(OrderEntry o1, OrderEntry o2) {
            return this.weight(o1) - this.weight(o2);
        }

        private int weight(OrderEntry e) {
            return e instanceof JdkOrderEntry ? 2 : (e instanceof ModuleSourceOrderEntry ? 0 : 1);
        }
    };
    private final com.intellij.openapi.project.Project myProject;
    private final Workspace myWorkspace;
    private final Collection<Project> myProjects;
    private final Map<String, String> mySourcesMap;

    private static boolean isUnitTestMode() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    public BndProjectImporter(@NotNull com.intellij.openapi.project.Project project, @NotNull Workspace workspace, @NotNull Collection<Project> toImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "<init>"));
        }
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "<init>"));
        }
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "<init>"));
        }
        this.mySourcesMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        this.myProject = project;
        this.myWorkspace = workspace;
        this.myProjects = toImport;
    }

    @NotNull
    public Module createRootModule(@NotNull ModifiableModuleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "createRootModule"));
        }
        String rootDir = this.myProject.getBasePath();
        assert (rootDir != null) : this.myProject;
        String imlPath = rootDir + File.separator + this.myProject.getName() + ".iml";
        Module module = model.newModule(imlPath, StdModuleTypes.JAVA.getId());
        ModuleRootModificationUtil.addContentRoot((Module)module, (String)rootDir);
        ModuleRootModificationUtil.setSdkInherited((Module)module);
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "createRootModule"));
        }
        return module2;
    }

    public void setupProject() {
        LanguageLevel sourceLevel = LanguageLevel.parse((String)this.myWorkspace.getProperty(JAVAC_SOURCE));
        if (sourceLevel != null) {
            LanguageLevelProjectExtension.getInstance((com.intellij.openapi.project.Project)this.myProject).setLanguageLevel(sourceLevel);
        }
        String targetLevel = this.myWorkspace.getProperty(JAVAC_TARGET);
        CompilerConfiguration.getInstance((com.intellij.openapi.project.Project)this.myProject).setProjectBytecodeTarget(targetLevel);
        JpsJavaCompilerOptions javacOptions = JavacConfiguration.getOptions((com.intellij.openapi.project.Project)this.myProject, JavacConfiguration.class);
        javacOptions.DEBUGGING_INFO = BndProjectImporter.booleanProperty(this.myWorkspace.getProperty("javac.debug", "true"));
        javacOptions.DEPRECATION = BndProjectImporter.booleanProperty(this.myWorkspace.getProperty("java.deprecation"));
        javacOptions.ADDITIONAL_OPTIONS_STRING = this.myWorkspace.getProperty("java.options", "");
    }

    public void resolve(final boolean refresh) {
        if (!BndProjectImporter.isUnitTestMode()) {
            new Task.Backgroundable(this.myProject, OsmorcBundle.message("bnd.import.resolve.task", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/osgi/bnd/imp/BndProjectImporter$2", "run"));
                    }
                    if (BndProjectImporter.this.resolve(indicator)) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            BndProjectImporter.this.createProjectStructure();
                            if (refresh) {
                                VirtualFileManager.getInstance().asyncRefresh(null);
                            }
                        }, BndProjectImporter.this.myProject.getDisposed());
                    }
                }
            }.queue();
        } else {
            this.resolve(null);
            this.createProjectStructure();
        }
    }

    private boolean resolve(@Nullable ProgressIndicator indicator) {
        int progress = 0;
        for (Project project : this.myProjects) {
            LOG.info("resolving: " + project.getBase());
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setText(project.getName());
            }
            try {
                project.prepare();
            }
            catch (Exception e) {
                this.checkErrors(project, e);
                return false;
            }
            this.checkWarnings(project, project.getErrors(), true);
            this.checkWarnings(project, project.getWarnings(), false);
            this.findSources(project);
            if (indicator == null) continue;
            indicator.setFraction((double)(++progress) / (double)this.myProjects.size());
        }
        return true;
    }

    private void findSources(Project project) {
        try {
            this.findSources(project.getBootclasspath());
            this.findSources(project.getBuildpath());
            this.findSources(project.getTestpath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSources(Collection<Container> classpath) {
        for (Container dependency : classpath) {
            String path;
            File file;
            Container.TYPE type = dependency.getType();
            if (type != Container.TYPE.REPO && type != Container.TYPE.EXTERNAL || !(file = dependency.getFile()).isFile() || !FileUtilRt.extensionEquals((String)file.getName(), (String)"jar") || this.mySourcesMap.containsKey(path = file.getPath())) continue;
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry srcRoot = zipFile.getEntry(SRC_ROOT);
                if (srcRoot == null) continue;
                this.mySourcesMap.put(path, SRC_ROOT);
            }
            catch (IOException e) {
                this.mySourcesMap.put(path, null);
            }
        }
    }

    private void createProjectStructure() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            LanguageLevel projectLevel = LanguageLevelProjectExtension.getInstance((com.intellij.openapi.project.Project)this.myProject).getLanguageLevel();
            HashMap rootModels = ContainerUtil.newHashMap();
            ModifiableModuleModel moduleModel = ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModifiableModel();
            LibraryTable.ModifiableModel libraryModel = ProjectLibraryTable.getInstance((com.intellij.openapi.project.Project)this.myProject).getModifiableModel();
            try {
                for (Project project : this.myProjects) {
                    try {
                        rootModels.put(project, this.createModule(moduleModel, project, projectLevel));
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
                for (Project project : this.myProjects) {
                    try {
                        this.setDependencies(moduleModel, libraryModel, (ModifiableRootModel)rootModels.get(project), project);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            finally {
                libraryModel.commit();
                ModifiableModelCommitter.multiCommit(rootModels.values(), (ModifiableModuleModel)moduleModel);
            }
        });
    }

    private ModifiableRootModel createModule(ModifiableModuleModel moduleModel, Project project, LanguageLevel projectLevel) throws Exception {
        String name = project.getName();
        Module module = moduleModel.findModuleByName(name);
        if (module == null) {
            String path = project.getBase().getPath() + File.separator + name + ".iml";
            module = moduleModel.newModule(path, StdModuleTypes.JAVA.getId());
        }
        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            rootModel.removeContentEntry(contentEntry);
        }
        for (ContentEntry contentEntry : rootModel.getOrderEntries()) {
            if (contentEntry instanceof ModuleJdkOrderEntry || contentEntry instanceof ModuleSourceOrderEntry) continue;
            rootModel.removeOrderEntry((OrderEntry)contentEntry);
        }
        rootModel.inheritSdk();
        ContentEntry contentEntry = rootModel.addContentEntry(BndProjectImporter.url(project.getBase()));
        for (File src : project.getSourcePath()) {
            contentEntry.addSourceFolder(BndProjectImporter.url(src), false);
        }
        File testSrc = project.getTestSrc();
        if (testSrc != null) {
            contentEntry.addSourceFolder(BndProjectImporter.url(testSrc), true);
        }
        contentEntry.addExcludeFolder(BndProjectImporter.url(project.getTarget()));
        LanguageLevel sourceLevel = LanguageLevel.parse((String)project.getProperty(JAVAC_SOURCE));
        if (sourceLevel == projectLevel) {
            sourceLevel = null;
        }
        ((LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(sourceLevel);
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        compilerModuleExtension.inheritCompilerOutputPath(false);
        compilerModuleExtension.setExcludeOutput(true);
        compilerModuleExtension.setCompilerOutputPath(BndProjectImporter.url(project.getSrcOutput()));
        compilerModuleExtension.setCompilerOutputPathForTests(BndProjectImporter.url(project.getTestOutput()));
        String targetLevel = project.getProperty(JAVAC_TARGET);
        CompilerConfiguration.getInstance((com.intellij.openapi.project.Project)this.myProject).setBytecodeTargetLevel(module, targetLevel);
        OsmorcFacet facet = OsmorcFacet.getInstance(module);
        if (project.isNoBundles() && facet != null) {
            FacetUtil.deleteFacet((Facet)facet);
            facet = null;
        } else if (!project.isNoBundles() && facet == null) {
            facet = (OsmorcFacet)FacetUtil.addFacet((Module)module, (FacetType)OsmorcFacetType.getInstance());
        }
        if (facet != null) {
            OsmorcFacetConfiguration facetConfig = (OsmorcFacetConfiguration)facet.getConfiguration();
            facetConfig.setManifestGenerationMode(ManifestGenerationMode.Bnd);
            facetConfig.setBndFileLocation(FileUtil.getRelativePath((String)BndProjectImporter.path(project.getBase()), (String)BndProjectImporter.path(project.getPropertiesFile()), (char)'/'));
            Map.Entry bsn = project.getBundleSymbolicName();
            File bundle = project.getOutputFile(bsn != null ? (String)bsn.getKey() : name, project.getBundleVersion());
            facetConfig.setJarFileLocation(BndProjectImporter.path(bundle), OutputPathType.SpecificOutputPath);
            facetConfig.setDoNotSynchronizeWithMaven(true);
        }
        return rootModel;
    }

    private void setDependencies(ModifiableModuleModel moduleModel, LibraryTable.ModifiableModel libraryModel, ModifiableRootModel rootModel, Project project) throws Exception {
        ArrayList warnings = ContainerUtil.newArrayList();
        Collection boot = project.getBootclasspath();
        HashSet bootSet = Collections.emptySet();
        if (!boot.isEmpty()) {
            this.setDependencies(moduleModel, libraryModel, rootModel, project, boot, false, bootSet, warnings);
            bootSet = ContainerUtil.newHashSet((Iterable)boot);
            OrderEntry[] entries = rootModel.getOrderEntries();
            if (entries.length > 2) {
                Arrays.sort(entries, ORDER_ENTRY_COMPARATOR);
                rootModel.rearrangeOrderEntries(entries);
            }
        }
        this.setDependencies(moduleModel, libraryModel, rootModel, project, project.getBuildpath(), false, bootSet, warnings);
        this.setDependencies(moduleModel, libraryModel, rootModel, project, project.getTestpath(), true, bootSet, warnings);
        this.checkWarnings(project, warnings, false);
    }

    private void setDependencies(ModifiableModuleModel moduleModel, LibraryTable.ModifiableModel libraryModel, ModifiableRootModel rootModel, Project project, Collection<Container> classpath, boolean tests, Set<Container> excluded, List<String> warnings) throws Exception {
        DependencyScope scope = tests ? DependencyScope.TEST : DependencyScope.COMPILE;
        for (Container dependency : classpath) {
            if (excluded.contains(dependency) || dependency.getType() == Container.TYPE.PROJECT && project == dependency.getProject()) continue;
            try {
                this.addEntry(moduleModel, libraryModel, rootModel, dependency, scope);
            }
            catch (IllegalArgumentException e) {
                warnings.add(e.getMessage());
            }
        }
    }

    private void addEntry(ModifiableModuleModel moduleModel, LibraryTable.ModifiableModel libraryModel, ModifiableRootModel rootModel, Container dependency, DependencyScope scope) throws IllegalArgumentException {
        ModuleOrderEntry entry;
        File file = dependency.getFile();
        String bsn = dependency.getBundleSymbolicName();
        String version = dependency.getVersion();
        String path = file.getPath();
        if (path.contains(": ")) {
            throw new IllegalArgumentException("Cannot resolve " + bsn + ":" + version + ": " + path);
        }
        if (JDK_DEPENDENCY.equals(bsn)) {
            ProjectJdkTable jdkTable;
            Sdk jdk;
            String name = BND_LIB_PREFIX + bsn + ":" + version;
            if (FileUtil.isAncestor((File)this.myWorkspace.getBase(), (File)file, (boolean)true)) {
                name = name + "-" + this.myProject.getName();
            }
            if ((jdk = (jdkTable = ProjectJdkTable.getInstance()).findJdk(name)) == null) {
                jdk = jdkTable.createSdk(name, (SdkTypeId)JavaSdk.getInstance());
                SdkModificator jdkModel = jdk.getSdkModificator();
                jdkModel.setHomePath(file.getParent());
                jdkModel.setVersionString(version);
                VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(BndProjectImporter.url(file));
                assert (root != null) : file + " " + file.exists();
                jdkModel.addRoot(root, OrderRootType.CLASSES);
                VirtualFile srcRoot = VirtualFileManager.getInstance().findFileByUrl(BndProjectImporter.url(file) + SRC_ROOT);
                if (srcRoot != null) {
                    jdkModel.addRoot(srcRoot, OrderRootType.SOURCES);
                }
                jdkModel.commitChanges();
                jdkTable.addJdk(jdk);
            }
            rootModel.setSdk(jdk);
            return;
        }
        switch (dependency.getType()) {
            case PROJECT: {
                String name = dependency.getProject().getName();
                Module module = moduleModel.findModuleByName(name);
                if (module == null) {
                    throw new IllegalArgumentException("Unknown module '" + name + "'");
                }
                entry = (ModuleOrderEntry)ContainerUtil.find((Object[])rootModel.getOrderEntries(), e -> e instanceof ModuleOrderEntry && ((ModuleOrderEntry)e).getModule() == module);
                if (entry != null) break;
                entry = rootModel.addModuleOrderEntry(module);
                break;
            }
            case REPO: {
                String name = BND_LIB_PREFIX + bsn + ":" + version;
                Library library = libraryModel.getLibraryByName(name);
                if (library == null) {
                    library = libraryModel.createLibrary(name);
                }
                Library.ModifiableModel model = library.getModifiableModel();
                for (String url : model.getUrls(OrderRootType.CLASSES)) {
                    model.removeRoot(url, OrderRootType.CLASSES);
                }
                for (String url : model.getUrls(OrderRootType.SOURCES)) {
                    model.removeRoot(url, OrderRootType.SOURCES);
                }
                model.addRoot(BndProjectImporter.url(file), OrderRootType.CLASSES);
                String srcRoot = this.mySourcesMap.get(path);
                if (srcRoot != null) {
                    model.addRoot(BndProjectImporter.url(file) + srcRoot, OrderRootType.SOURCES);
                }
                model.commit();
                entry = rootModel.addLibraryEntry(library);
                break;
            }
            case EXTERNAL: {
                Library library = rootModel.getModuleLibraryTable().createLibrary(file.getName());
                Library.ModifiableModel model = library.getModifiableModel();
                model.addRoot(BndProjectImporter.url(file), OrderRootType.CLASSES);
                String srcRoot = this.mySourcesMap.get(path);
                if (srcRoot != null) {
                    model.addRoot(BndProjectImporter.url(file) + srcRoot, OrderRootType.SOURCES);
                }
                model.commit();
                entry = rootModel.findLibraryOrderEntry(library);
                assert (entry != null) : library;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown dependency '" + dependency + "' of type " + dependency.getType());
            }
        }
        entry.setScope(scope);
    }

    private void checkErrors(Project project, Exception e) {
        if (BndProjectImporter.isUnitTestMode()) {
            throw new AssertionError((Object)e);
        }
        LOG.warn((Throwable)e);
        String text = OsmorcBundle.message("bnd.import.resolve.error", project.getName(), e.getMessage());
        NOTIFICATIONS.createNotification(OsmorcBundle.message("bnd.import.error.title", new Object[0]), text, NotificationType.ERROR, null).notify(this.myProject);
    }

    private void checkWarnings(Project project, List<String> warnings, boolean error) {
        if (warnings != null && !warnings.isEmpty()) {
            if (!BndProjectImporter.isUnitTestMode()) {
                LOG.warn(warnings.toString());
                String text = OsmorcBundle.message("bnd.import.warn.text", project.getName(), "<br>" + StringUtil.join(warnings, (String)"<br>"));
                NotificationType type = error ? NotificationType.ERROR : NotificationType.WARNING;
                NOTIFICATIONS.createNotification(OsmorcBundle.message("bnd.import.warn.title", new Object[0]), text, type, null).notify(this.myProject);
            } else {
                throw new AssertionError((Object)warnings.toString());
            }
        }
    }

    private static boolean booleanProperty(String value) {
        return "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    private static String path(File file) {
        return FileUtil.toSystemIndependentName((String)file.getPath());
    }

    private static String url(File file) {
        return VfsUtil.getUrlForLibraryRoot((File)file);
    }

    @NotNull
    public static Collection<Project> getWorkspaceProjects(@NotNull Workspace workspace) throws Exception {
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "getWorkspaceProjects"));
        }
        List list = ContainerUtil.filter((Collection)workspace.getAllProjects(), (Condition)Condition.NOT_NULL);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "getWorkspaceProjects"));
        }
        return list;
    }

    @Nullable
    public static Workspace findWorkspace(@NotNull com.intellij.openapi.project.Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "findWorkspace"));
        }
        String basePath = project.getBasePath();
        if (basePath != null && new File(basePath, CNF_DIR).exists()) {
            try {
                Workspace ws = Workspace.getWorkspace((File)new File(basePath), (String)CNF_DIR);
                BND_WORKSPACE_KEY.set((UserDataHolder)project, (Object)ws);
                return ws;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static Workspace getWorkspace(@Nullable com.intellij.openapi.project.Project project) {
        return project == null || project.isDefault() ? null : (Workspace)BND_WORKSPACE_KEY.get((UserDataHolder)project);
    }

    public static void reimportWorkspace(final @NotNull com.intellij.openapi.project.Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "reimportWorkspace"));
        }
        if (!BndProjectImporter.isUnitTestMode()) {
            new Task.Backgroundable(project, OsmorcBundle.message("bnd.reimport.task", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/osgi/bnd/imp/BndProjectImporter$3", "run"));
                    }
                    BndProjectImporter.doReimportWorkspace(project, indicator);
                }
            }.queue();
        } else {
            BndProjectImporter.doReimportWorkspace(project, null);
        }
    }

    private static void doReimportWorkspace(com.intellij.openapi.project.Project project, ProgressIndicator indicator) {
        Collection<Project> projects;
        Workspace workspace = BndProjectImporter.getWorkspace(project);
        assert (workspace != null) : project;
        try {
            workspace.clear();
            workspace.forceRefresh();
            BndProjectImporter.refreshRepositories(workspace, indicator);
            projects = BndProjectImporter.getWorkspaceProjects(workspace);
            for (Project p : projects) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                p.clear();
                p.forceRefresh();
            }
        }
        catch (Exception e) {
            LOG.error("ws=" + workspace.getBase(), (Throwable)e);
            return;
        }
        Runnable task = () -> {
            BndProjectImporter importer = new BndProjectImporter(project, workspace, projects);
            importer.setupProject();
            importer.resolve(true);
        };
        if (!BndProjectImporter.isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(task, project.getDisposed());
        } else {
            task.run();
        }
    }

    public static void reimportProjects(final @NotNull com.intellij.openapi.project.Project project, final @NotNull Collection<String> projectDirs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "reimportProjects"));
        }
        if (projectDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDirs", "org/jetbrains/osgi/bnd/imp/BndProjectImporter", "reimportProjects"));
        }
        if (!BndProjectImporter.isUnitTestMode()) {
            new Task.Backgroundable(project, OsmorcBundle.message("bnd.reimport.task", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/osgi/bnd/imp/BndProjectImporter$4", "run"));
                    }
                    BndProjectImporter.doReimportProjects(project, projectDirs, indicator);
                }
            }.queue();
        } else {
            BndProjectImporter.doReimportProjects(project, projectDirs, null);
        }
    }

    private static void doReimportProjects(com.intellij.openapi.project.Project project, Collection<String> projectDirs, ProgressIndicator indicator) {
        ArrayList projects;
        Workspace workspace = BndProjectImporter.getWorkspace(project);
        assert (workspace != null) : project;
        try {
            BndProjectImporter.refreshRepositories(workspace, indicator);
            projects = ContainerUtil.newArrayListWithCapacity((int)projectDirs.size());
            for (String dir : projectDirs) {
                Project p;
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                if ((p = workspace.getProject(PathUtil.getFileName((String)dir))) == null) continue;
                p.clear();
                p.forceRefresh();
                projects.add(p);
            }
        }
        catch (Exception e) {
            LOG.error("ws=" + workspace.getBase() + " pr=" + projectDirs, (Throwable)e);
            return;
        }
        Runnable task = () -> new BndProjectImporter(project, workspace, projects).resolve(true);
        if (!BndProjectImporter.isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(task, project.getDisposed());
        } else {
            task.run();
        }
    }

    private static void refreshRepositories(Workspace workspace, ProgressIndicator indicator) {
        List plugins = workspace.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin plugin : plugins) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (!(plugin instanceof Refreshable)) continue;
            try {
                ((Refreshable)plugin).refresh();
            }
            catch (Exception e) {
                LOG.warn((String)ObjectUtils.notNull((Object)e.getMessage(), (Object)"NPE") + ", plugin=" + plugin);
                LOG.debug((Throwable)e);
            }
        }
    }
}

