/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssUriImpl;
import com.intellij.psi.css.impl.stubs.CssImportStub;
import com.intellij.psi.css.impl.stubs.CssImportStubElementType;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssImportImpl
extends CssStubElement<CssImportStub>
implements CssImport {
    public static final ArrayFactory<CssImport> ARRAY_FACTORY = count -> count == 0 ? CssImport.EMPTY_ARRAY : new CssImport[count];

    public CssImportImpl(@NotNull CssImportStub stub, @NotNull CssImportStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssImportImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssImportImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssImportImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssImportImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public String[] getUriStrings() {
        CssImportStub stub = (CssImportStub)this.getStub();
        if (stub != null) {
            String[] stringArray = stub.getPaths();
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getUriStrings"));
            }
            return stringArray;
        }
        List result = ContainerUtil.newSmartList();
        for (PsiElement element : this.getUriElements()) {
            Pair<String, TextRange> data = CssReferenceProviderUtil.getFileReferenceData(element);
            if (data == null) continue;
            result.add(data.first);
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getUriStrings"));
        }
        return stringArray;
    }

    @NotNull
    public PsiElement[] getUriElements() {
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssString.class));
        List uris = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssUriImpl.class);
        for (CssUriImpl uri : uris) {
            PsiElement valueElement = uri.getValueElement();
            if (valueElement == null || valueElement instanceof PsiErrorElement) continue;
            result.add(valueElement);
        }
        PsiElement[] psiElementArray = !result.isEmpty() ? result.toArray(new PsiElement[result.size()]) : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getUriElements"));
        }
        return psiElementArray;
    }

    @Nullable
    public CssMediumList getMediumList() {
        return (CssMediumList)PsiTreeUtil.getChildOfType((PsiElement)this, CssMediumList.class);
    }

    public boolean isScreen() {
        return this.getMediaTypes().contains(CssMediaType.SCREEN);
    }

    @NotNull
    public Set<CssMediaType> getMediaTypes() {
        CssImportStub stub = (CssImportStub)this.getStub();
        if (stub != null) {
            Set<CssMediaType> set = stub.getMediaTypes();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getMediaTypes"));
            }
            return set;
        }
        CssMediumList mediumList = this.getMediumList();
        Set<CssMediaType> set = mediumList != null ? mediumList.getTypes() : Collections.singleton(CssMediaType.SCREEN);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getMediaTypes"));
        }
        return set;
    }

    @Nullable
    public CssAtRule getSupports() {
        return (CssAtRule)ObjectUtils.tryCast((Object)this.findChildByType(CssElementTypes.CSS_SUPPORTS), CssAtRule.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssImportImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssImport((CssImport)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiFile[] resolve() {
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement element : this.getUriElements()) {
            Collections.addAll(result, CssResolveManager.getInstance().resolveFiles(element, this.getContainingFile()));
        }
        PsiFile[] psiFileArray = !result.isEmpty() ? result.toArray(new PsiFile[result.size()]) : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "resolve"));
        }
        return psiFileArray;
    }
}

