/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.impl.CssImportImpl;
import com.intellij.psi.css.impl.stubs.CssImportStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CssImportStubElementType
extends CssStubElementType<CssImportStub, CssImport> {
    public CssImportStubElementType() {
        super("CSS_IMPORT");
    }

    @Override
    public PsiElement createElement(ASTNode node) {
        return new CssImportImpl(node);
    }

    public CssImport createPsi(@NotNull CssImportStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/stubs/CssImportStubElementType", "createPsi"));
        }
        return new CssImportImpl(stub, this);
    }

    @NotNull
    public CssImportStub createStub(@NotNull CssImport psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/css/impl/stubs/CssImportStubElementType", "createStub"));
        }
        CssImportStub cssImportStub = new CssImportStub(psi.getUriStrings(), psi.getParent() instanceof CssImportList, psi.getMediaTypes(), parentStub, this);
        if (cssImportStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/stubs/CssImportStubElementType", "createStub"));
        }
        return cssImportStub;
    }

    public void serialize(@NotNull CssImportStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/stubs/CssImportStubElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/css/impl/stubs/CssImportStubElementType", "serialize"));
        }
        dataStream.writeUTFFast(StringUtil.join((String[])stub.getPaths(), (String)File.pathSeparator));
        dataStream.writeBoolean(stub.isFromImportList());
        CssIndexUtil.writeMediaTypes(dataStream, stub.getMediaTypes());
    }

    @NotNull
    public CssImportStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/css/impl/stubs/CssImportStubElementType", "deserialize"));
        }
        List paths = StringUtil.split((String)dataStream.readUTFFast(), (String)File.pathSeparator);
        boolean fromImportList = dataStream.readBoolean();
        CssImportStub cssImportStub = new CssImportStub(ArrayUtil.toStringArray((Collection)paths), fromImportList, CssIndexUtil.readMediaTypes(dataStream), parentStub, this);
        if (cssImportStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/stubs/CssImportStubElementType", "deserialize"));
        }
        return cssImportStub;
    }
}

