/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.stubs.CssSimpleSelectorStubElementType;
import com.intellij.psi.css.impl.stubs.CssStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSimpleSelectorStub
extends CssStub<CssSimpleSelector> {
    private final String myNamespaceName;
    private final String myElementName;

    public CssSimpleSelectorStub(@Nullable String namespaceName, @NotNull String elementName, StubElement parent, @NotNull CssSimpleSelectorStubElementType type) {
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "com/intellij/psi/css/impl/stubs/CssSimpleSelectorStub", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/stubs/CssSimpleSelectorStub", "<init>"));
        }
        super(parent, type);
        this.myElementName = elementName;
        this.myNamespaceName = namespaceName;
    }

    @Nullable
    public String getNamespaceName() {
        return this.myNamespaceName;
    }

    @NotNull
    public String getElementName() {
        String string = this.myElementName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/stubs/CssSimpleSelectorStub", "getElementName"));
        }
        return string;
    }

    public boolean isAmpersandSelector() {
        if (StringUtil.containsChar((String)this.getElementName(), (char)'&')) {
            return true;
        }
        for (StubElement childStub : this.getChildrenStubs()) {
            if (!(childStub instanceof CssNamedStub) || !StringUtil.containsChar((String)((CssNamedStub)childStub).getName(), (char)'&')) continue;
            return true;
        }
        return false;
    }
}

