/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.css.util.CssImageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.css.util.CssUriUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.io.URLUtil;
import java.util.Collection;
import org.intellij.images.index.ImageInfoIndex;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImageSizeCompletionProvider
extends CompletionProvider<CompletionParameters> {
    ImageSizeCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/ImageSizeCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/ImageSizeCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)position, CssDeclaration.class);
        if (declaration == null) {
            return;
        }
        String propertyName = declaration.getPropertyName();
        if ("width".equalsIgnoreCase(propertyName) || "height".equalsIgnoreCase(propertyName)) {
            CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)position, CssBlock.class);
            if (block == null) {
                return;
            }
            for (CssUri imageUri : CssImageUtil.findBackgroundImageUrlsInBlock((CssBlock)block)) {
                VirtualFile file;
                Collection files = CssImageUtil.getImageFiles((CssElement)imageUri);
                VirtualFile virtualFile = file = files.size() == 1 ? (VirtualFile)Iterables.getFirst((Iterable)files, null) : null;
                if (file != null) {
                    ImageInfoIndex.processValues((VirtualFile)file, (file1, value) -> {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/ImageSizeCompletionProvider", "lambda$addCompletions$0"));
                        }
                        ImageSizeCompletionProvider.addCompletion(result, propertyName, value, position.getManager().findFile(file1));
                        return true;
                    }, (Project)imageUri.getProject());
                    continue;
                }
                if (!CssUriUtil.isDataUri((PsiElement)imageUri)) continue;
                ImageInfoIndex.ImageInfo info = (ImageInfoIndex.ImageInfo)CachedValuesManager.getCachedValue((PsiElement)imageUri, () -> {
                    byte[] imageBytes = URLUtil.getBytesFromDataUri((String)imageUri.getValue());
                    if (imageBytes != null) {
                        try {
                            ImageInfoReader.Info info1 = ImageInfoReader.getInfo((byte[])imageBytes);
                            if (info1 != null) {
                                return CachedValueProvider.Result.create((Object)new ImageInfoIndex.ImageInfo(info1.width, info1.height, info1.bpp), (Object[])new Object[]{imageUri});
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{imageUri});
                });
                ImageSizeCompletionProvider.addCompletion(result, propertyName, info, null);
            }
        }
    }

    private static void addCompletion(@NotNull CompletionResultSet result, @NotNull String propertyName, @Nullable ImageInfoIndex.ImageInfo info, @Nullable PsiFile psiImageFile) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/ImageSizeCompletionProvider", "addCompletion"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/completion/ImageSizeCompletionProvider", "addCompletion"));
        }
        if (info != null && info.width > 0 && info.height > 0) {
            if ("width".equalsIgnoreCase(propertyName)) {
                result.addElement(CssCompletionUtil.lookupItemForImageSize(info.width, psiImageFile));
            }
            if ("height".equalsIgnoreCase(propertyName)) {
                result.addElement(CssCompletionUtil.lookupItemForImageSize(info.height, psiImageFile));
            }
        }
    }
}

