/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssValueDeclaration;
import com.intellij.psi.css.CssValueImportedAlias;
import com.intellij.psi.css.CssValueRule;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueReference
extends PsiReferenceBase<PsiElement>
implements CssReference {
    private static final ResolveCache.AbstractResolver<CssValueReference, CssNamedElement> RESOLVER = new ResolveCache.AbstractResolver<CssValueReference, CssNamedElement>(){

        @Nullable
        public CssNamedElement resolve(@NotNull CssValueReference reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/css/resolve/CssValueReference$1", "resolve"));
            }
            String text = reference.getValue();
            if (text.isEmpty()) {
                return null;
            }
            Ref result = Ref.create();
            CssValueReference.processValueRules(reference.getElement(), (Processor<CssNamedElement>)element -> {
                if (text.equals(element.getName())) {
                    result.set(element);
                    return false;
                }
                return true;
            });
            return (CssNamedElement)result.get();
        }
    };

    public CssValueReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/resolve/CssValueReference", "<init>"));
        }
        super(element);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = "@value " + this.getCanonicalText() + " not found";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssValueReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
    }

    @NotNull
    public Object[] getVariants() {
        SmartList result = new SmartList();
        CssValueReference.processValueRules(this.myElement, (Processor<CssNamedElement>)((Processor)element -> {
            String name = element.getName();
            if (name != null) {
                ItemPresentation presentation;
                LookupElementBuilder lookup = LookupElementBuilder.create((PsiNamedElement)element).withIcon(CssValueRule.ICON).withTypeText("@value");
                if (element instanceof CssValueDeclaration) {
                    lookup = lookup.withTailText(" " + ((CssValueDeclaration)element).getValueValueText(), true);
                } else if (element instanceof CssValueImportedAlias && (presentation = element.getPresentation()) != null && presentation.getLocationString() != null) {
                    String text = name.equals(presentation.getPresentableText()) ? " from " + presentation.getLocationString() : " " + presentation.getPresentableText() + " from " + presentation.getLocationString();
                    lookup = lookup.withTailText(text, true);
                }
                result.add((Object)lookup);
            }
            return true;
        }));
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssValueReference", "getVariants"));
        }
        return objectArray;
    }

    private static void processValueRules(@NotNull PsiElement element, @NotNull Processor<CssNamedElement> processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/resolve/CssValueReference", "processValueRules"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/resolve/CssValueReference", "processValueRules"));
        }
        CssRulesetList rulesetList = (CssRulesetList)PsiTreeUtil.getParentOfType((PsiElement)element, CssRulesetList.class);
        if (rulesetList == null) {
            return;
        }
        for (PsiElement child = rulesetList.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof CssValueRule) || ((CssValueRule)child).processValueDeclaringElements(processor)) continue;
            return;
        }
    }
}

