/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssCompositeElementDescriptor;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssNavigableDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.descriptor.visitor.CssParameterInfoValueDescriptorsVisitor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ui.RowIcon;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompletionUtil {
    public static final int CSS_SELECTOR_SUFFIX_PRIORITY = 20;
    public static final int CSS_SELECTOR_SUFFIX_FROM_HTML_PRIORITY = 10;
    public static final int CSS_KEYWORDS_PRIORITY = 20;
    public static final int CSS_PSEUDO_SELECTOR_PRIORITY = 10;
    public static final int CSS_PROPERTY_NAME_PRIORITY = 10;
    public static final int CSS_CUSTOM_PROPERTY_DECLARATION_PRIORITY = 9;
    private static final InsertHandler<LookupElement> SELECTOR_SUFFIX_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            PsiElement element = item.getPsiElement();
            if (element instanceof CssSelectorSuffix) {
                Document document = context.getDocument();
                int startOffset = context.getStartOffset();
                int tailOffset = context.getTailOffset();
                if (0 <= startOffset && startOffset < document.getTextLength() && 0 <= tailOffset && tailOffset < document.getTextLength()) {
                    document.replaceString(startOffset, tailOffset, (CharSequence)item.getLookupString());
                }
            }
        }
    };

    @NotNull
    public static LookupElement lookupForSelectorSuffix(@NotNull String name, @NotNull CssSelectorSuffix selectorSuffix, @NotNull PsiElement navigationElement, @Nullable PsiFile contextFile) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        if (selectorSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)navigationElement).withInsertHandler(SELECTOR_SUFFIX_INSERT_HANDLER);
        ItemPresentation presentation = selectorSuffix.getPresentation();
        assert (presentation != null);
        if (selectorSuffix != navigationElement && presentation instanceof CssNamedItemPresentation) {
            presentation = new CssNamedItemPresentation.WithCustomContext((CssNamedItemPresentation)presentation, navigationElement);
        }
        int priority = 20;
        PsiFile containingFile = navigationElement.getContainingFile();
        if (contextFile == containingFile) {
            priority += 10;
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withIcon(presentation.getIcon(false)).withTypeText(presentation.getLocationString()), (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupForSelectorSuffixFromHtml(@NotNull String name, @NotNull CssSelectorSuffixType type, @Nullable VirtualFile containingFile, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        LookupElement lookupElement = CssCompletionUtil.lookupForSelectorSuffixFromHtml(name, type, containingFile, project, 0);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupForSelectorSuffixFromHtml(@NotNull String name, @NotNull CssSelectorSuffixType type, @Nullable VirtualFile containingFile, @Nullable Project project, int extraPriority) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)name).withIcon(type.getIcon()).withTypeText(containingFile != null ? CssCompletionUtil.getContainingFileText(containingFile, project) : "from html").withInsertHandler(SELECTOR_SUFFIX_INSERT_HANDLER);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder, (double)(10 + extraPriority));
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        return lookupElement;
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForKeyword"));
        }
        return CssCompletionUtil.lookupForKeyword(lookupString, null);
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForKeyword"));
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)lookupString).bold().withInsertHandler(insertHandler);
        return PrioritizedLookupElement.withPriority((LookupElement)builder, (double)20.0);
    }

    private static String getContainingFileText(@NotNull VirtualFile file, @Nullable Project project) {
        String relativePath;
        ProjectFileIndex index;
        VirtualFile rootForFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/util/CssCompletionUtil", "getContainingFileText"));
        }
        if (project != null && (rootForFile = (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).getContentRootForFile(file)) != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)rootForFile, (char)File.separatorChar)) != null) {
            return relativePath;
        }
        return file.getName();
    }

    @NotNull
    public static CompletionResultSet fixPrefixForVendorPrefixes(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, IElementType ... typesToFix) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
        }
        if (typesToFix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesToFix", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
        }
        PsiElement position = parameters.getPosition();
        IElementType type = position.getNode().getElementType();
        if (CssElementTypes.NAME_TOKEN_TYPES.contains(type) || type == CssElementTypes.CSS_ATKEYWORD || TokenSet.create((IElementType[])typesToFix).contains(type)) {
            String positionText = position.getText();
            int prefixShift = parameters.getOffset() - position.getTextRange().getStartOffset();
            if (0 < prefixShift && prefixShift < positionText.length()) {
                CompletionResultSet completionResultSet = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(positionText.substring(0, prefixShift)));
                if (completionResultSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
                }
                return completionResultSet;
            }
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "fixPrefixForVendorPrefixes"));
        }
        return completionResultSet;
    }

    @NotNull
    public static Collection<LookupElement> lookupItemsForDescriptors(@NotNull Collection<? extends CssElementDescriptor> descriptors, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        Collection<LookupElement> collection = CssCompletionUtil.lookupItemsForDescriptors(descriptors, insertHandler, (NotNullFunction<CssElementDescriptor, String>)CssDescriptorsUtil.GET_DESCRIPTOR_ID_FUNCTION, priority);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static Collection<LookupElement> lookupItemsForDescriptors(@NotNull Collection<? extends CssElementDescriptor> descriptors, @Nullable InsertHandler<LookupElement> insertHandler, @NotNull NotNullFunction<CssElementDescriptor, String> extractLookupStringFunction, int priority) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        if (extractLookupStringFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractLookupStringFunction", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        MultiMap map = MultiMap.create();
        for (CssElementDescriptor cssElementDescriptor : descriptors) {
            map.putValue((Object)cssElementDescriptor.getId(), (Object)cssElementDescriptor);
        }
        for (Map.Entry entry : map.entrySet()) {
            CssElementDescriptor descriptor = CssCompositeElementDescriptor.create((Collection)((Collection)entry.getValue()));
            if (descriptor == null) continue;
            result.add(CssCompletionUtil.lookupItemForDescriptor((String)extractLookupStringFunction.fun((Object)descriptor), descriptor, insertHandler, priority));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public static LookupElement lookupItemForDescriptor(@NotNull CssElementDescriptor descriptor, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        LookupElement lookupElement = CssCompletionUtil.lookupItemForDescriptor(descriptor.getId(), descriptor, insertHandler, priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupItemForDescriptor(@NotNull String lookupString, @NotNull CssElementDescriptor descriptor, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        String typeText;
        PsiElement element;
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        CssElementDescriptor.CssVersion version = descriptor.getCssVersion();
        Icon browsersIcon = CssCompletionUtil.getBrowsersIcon(lookupString, descriptor);
        if (browsersIcon != null) {
            browsersIcon = IconLoader.getTransparentIcon((Icon)browsersIcon, (float)0.6f);
        }
        PsiElement psiElement = element = descriptor instanceof CssNavigableDescriptor ? ((CssNavigableDescriptor)descriptor).getElement() : null;
        if (element != null) {
            ItemPresentation presentation = element instanceof NavigationItem ? ((NavigationItem)element).getPresentation() : null;
            typeText = presentation == null ? null : presentation.getLocationString();
        } else {
            typeText = version == CssElementDescriptor.CssVersion.UNKNOWN ? null : version.getPresentableName();
        }
        PsiElement lookupObject = descriptor instanceof CssNavigableDescriptor ? ((CssNavigableDescriptor)descriptor).getElement() : null;
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)ObjectUtils.notNull((Object)lookupObject, (Object)descriptor), (String)lookupString).withIcon(descriptor.getIcon()).withTailText(CssCompletionUtil.descriptorTailText(descriptor), true).withTypeText(typeText, browsersIcon, true).withInsertHandler(insertHandler);
        if (CssPropertyUtil.isVendorSpecificElement(descriptor.getId()) || version == CssElementDescriptor.CssVersion.UNKNOWN) {
            --priority;
        }
        if (descriptor.getId().startsWith("mso-")) {
            priority -= 2;
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElementBuilder, (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        return lookupElement;
    }

    private static String descriptorTailText(@NotNull CssElementDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/util/CssCompletionUtil", "descriptorTailText"));
        }
        if (descriptor instanceof CssFunctionDescriptor) {
            CssParameterInfoValueDescriptorsVisitor messageBuilder = new CssParameterInfoValueDescriptorsVisitor(null, true, false);
            ((CssFunctionDescriptor)descriptor).getValueDescriptor().accept((CssValueDescriptorVisitor)messageBuilder);
            return "(" + StringUtil.unescapeXml((String)messageBuilder.getParameterInfo()) + ")";
        }
        return null;
    }

    @Nullable
    private static Icon getBrowsersIcon(@NotNull String lookupString, @NotNull CssElementDescriptor descriptor) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/util/CssCompletionUtil", "getBrowsersIcon"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/util/CssCompletionUtil", "getBrowsersIcon"));
        }
        BrowserVersion[] browsers = descriptor.getBrowsers();
        if (browsers.length > 0 && browsers.length < BrowserVersion.Browser.values().length) {
            RowIcon icon = new RowIcon(browsers.length);
            for (int i = 0; i < browsers.length; ++i) {
                icon.setIcon(browsers[i].getBrowser().getIcon(), i);
            }
            return icon;
        }
        if (lookupString.startsWith("-ms-") || lookupString.startsWith("mso-")) {
            return BrowserVersion.Browser.IE.getIcon();
        }
        if (lookupString.startsWith("-moz-")) {
            return BrowserVersion.Browser.FIREFOX.getIcon();
        }
        if (lookupString.startsWith("-webkit-")) {
            RowIcon icon = new RowIcon(2);
            icon.setIcon(BrowserVersion.Browser.CHROME.getIcon(), 0);
            icon.setIcon(BrowserVersion.Browser.SAFARI.getIcon(), 1);
            return icon;
        }
        if (lookupString.startsWith("-o-")) {
            return BrowserVersion.Browser.OPERA.getIcon();
        }
        return null;
    }
}

