/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.framework;

import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.sdk.impl.GwtVersionImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.vaadin.framework.VaadinVersion;
import com.intellij.vaadin.framework.VaadinVersionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaadinVersionUtil {
    @NotNull
    public static VaadinVersion getVaadinVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/vaadin/framework/VaadinVersionUtil", "getVaadinVersion"));
        }
        VaadinVersion version = VaadinVersionUtil.getVersionOrNull(module);
        VaadinVersion vaadinVersion = version != null ? version : VaadinVersionUtil.getDefaultVersion();
        if (vaadinVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/framework/VaadinVersionUtil", "getVaadinVersion"));
        }
        return vaadinVersion;
    }

    @NotNull
    public static VaadinVersion getDefaultVersion() {
        VaadinVersionImpl vaadinVersionImpl = VaadinVersionImpl.V7_OR_LATER;
        if (vaadinVersionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/framework/VaadinVersionUtil", "getDefaultVersion"));
        }
        return vaadinVersionImpl;
    }

    public static VaadinVersion[] getAllVersions() {
        return VaadinVersionImpl.values();
    }

    @Nullable
    private static VaadinVersion getVersionOrNull(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/vaadin/framework/VaadinVersionUtil", "getVersionOrNull"));
        }
        return (VaadinVersion)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/vaadin/framework/VaadinVersionUtil", "lambda$getVersionOrNull$0"));
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            Object[] dependencies = new Object[]{ProjectRootManager.getInstance((Project)module.getProject())};
            for (VaadinVersion version : VaadinVersionUtil.getAllVersions()) {
                if (psiFacade.findClass(version.getServletClass(), scope) == null) continue;
                return CachedValueProvider.Result.create((Object)version, (Object[])dependencies);
            }
            return CachedValueProvider.Result.create(null, (Object[])dependencies);
        });
    }

    public static boolean hasVaadinFramework(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/vaadin/framework/VaadinVersionUtil", "hasVaadinFramework"));
        }
        return VaadinVersionUtil.getVersionOrNull(module) != null;
    }

    @Nullable
    private static VirtualFile findVaadinJar(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/vaadin/framework/VaadinVersionUtil", "findVaadinJar"));
        }
        VaadinVersion version = VaadinVersionUtil.getVersionOrNull(module);
        if (version == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(version.getServletClass(), scope);
        if (aClass == null) {
            return null;
        }
        PsiFile file = aClass.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        VirtualFile root = index.getClassRootForFile(virtualFile);
        return VfsUtilCore.getVirtualFileForJar((VirtualFile)root);
    }

    @Nullable
    public static String detectVaadinHome(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/vaadin/framework/VaadinVersionUtil", "detectVaadinHome"));
        }
        VirtualFile jar = VaadinVersionUtil.findVaadinJar(module);
        return jar != null ? jar.getParent().getPath() : null;
    }

    @NotNull
    public static GwtVersion getGwtVersion(@Nullable String vaadinVersion) {
        if (vaadinVersion == null) {
            GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_7;
            if (gwtVersionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/framework/VaadinVersionUtil", "getGwtVersion"));
            }
            return gwtVersionImpl;
        }
        if (VersionComparatorUtil.compare((String)vaadinVersion, (String)"7.2.0") < 0) {
            GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_5;
            if (gwtVersionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/framework/VaadinVersionUtil", "getGwtVersion"));
            }
            return gwtVersionImpl;
        }
        if (VersionComparatorUtil.compare((String)vaadinVersion, (String)"7.4.0") < 0) {
            GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_6;
            if (gwtVersionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/framework/VaadinVersionUtil", "getGwtVersion"));
            }
            return gwtVersionImpl;
        }
        if (VersionComparatorUtil.compare((String)vaadinVersion, (String)"8.0.0") < 0) {
            GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_7;
            if (gwtVersionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/framework/VaadinVersionUtil", "getGwtVersion"));
            }
            return gwtVersionImpl;
        }
        GwtVersionImpl gwtVersionImpl = GwtVersionImpl.VERSION_2_8;
        if (gwtVersionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/framework/VaadinVersionUtil", "getGwtVersion"));
        }
        return gwtVersionImpl;
    }
}

