/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts.plan;

import com.intellij.dmserver.artifacts.PsiConfigManagerBase;
import com.intellij.dmserver.artifacts.plan.PlanArtifactElement;
import com.intellij.dmserver.artifacts.plan.PlanRootElement;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.facet.DMUnitDescriptor;
import com.intellij.dmserver.facet.DMUnitDescriptorProvider;
import com.intellij.dmserver.facet.NestedUnitIdentity;
import com.intellij.dmserver.util.ModuleUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.VersionRange;

public class PlanFileManager
extends PsiConfigManagerBase<XmlFile, DMCompositeFacetConfiguration, DMCompositeFacet> {
    private static final Logger LOG = Logger.getInstance(PlanFileManager.class);
    @NonNls
    private static final String TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<plan\n\txmlns=\"http://www.springsource.org/schema/dm-server/plan\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\t\t\txsi:schemaLocation=\"\n\t\t\thttp://www.springsource.org/schema/dm-server/plan\n\t\t\thttp://www.springsource.org/schema/dm-server/plan/springsource-dm-server-plan.xsd\"\n/>";
    private final Module myModule;
    private final Project myProject;
    private final DomManager myDomManager;
    private final PsiManager myPsiManager;
    private boolean myInFileUpdate = false;

    public PlanFileManager(Module module) {
        this.myModule = module;
        this.myProject = module.getProject();
        this.myPsiManager = PsiManager.getInstance((Project)this.myProject);
        this.myDomManager = DomManager.getDomManager((Project)this.myProject);
    }

    public PlanFileCreator createPlan(ModuleRootModel rootModel) {
        return new PlanFileCreator(rootModel);
    }

    private String getFileName() {
        return this.myModule.getName();
    }

    private String getFileNameWithExt() {
        return this.getFileName() + "." + "plan";
    }

    @Nullable
    private PlanRootElement getFileRootElement(XmlFile planFile) {
        DomFileElement fileElement = this.myDomManager.getFileElement(planFile, PlanRootElement.class);
        return fileElement == null ? null : (PlanRootElement)fileElement.getRootElement();
    }

    @Nullable
    private PsiDirectory getPlanFileDirectory(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/plan/PlanFileManager", "getPlanFileDirectory"));
        }
        VirtualFile planVirtualDirectory = ModuleUtils.getModuleRoot(rootModel);
        return this.myPsiManager.findDirectory(planVirtualDirectory);
    }

    @Nullable
    private XmlFile getPlanFile(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/plan/PlanFileManager", "getPlanFile"));
        }
        PsiDirectory planDirectory = this.getPlanFileDirectory(rootModel);
        return planDirectory == null ? null : (XmlFile)planDirectory.findFile(this.getFileNameWithExt());
    }

    @Nullable
    public XmlFile findPlanFile() {
        return this.getPlanFile((ModuleRootModel)ModuleRootManager.getInstance((Module)this.myModule));
    }

    @Override
    protected XmlFile findConfigFile(Module module) {
        return this.findPlanFile();
    }

    @Override
    protected boolean onConfigFileChanged(DMCompositeFacetConfiguration configuration2update, XmlFile configWrapper) {
        if (this.myInFileUpdate) {
            return false;
        }
        PlanRootElement rootElement = this.getFileRootElement(configWrapper);
        if (rootElement == null) {
            rootElement = (PlanRootElement)this.myDomManager.createMockElement(PlanRootElement.class, null, false);
        }
        configuration2update.setName(PlanFileManager.safeValue(rootElement.getName().getValue(), ""));
        configuration2update.setVersion(PlanFileManager.safeValue(rootElement.getVersion().getValue(), ""));
        configuration2update.setScoped(PlanFileManager.safeValue(rootElement.getScoped().getValue(), false));
        configuration2update.setAtomic(PlanFileManager.safeValue(rootElement.getAtomic().getValue(), false));
        ArrayList<NestedUnitIdentity> nestedUnitIdentities = new ArrayList<NestedUnitIdentity>();
        for (PlanArtifactElement artifactElement : rootElement.getArtifacts()) {
            Module module;
            String artifactName = (String)artifactElement.getName().getValue();
            if (artifactName == null || (module = this.findModuleBySymbolicName(artifactName)) == null) continue;
            NestedUnitIdentity nestedUnitIdentity = new NestedUnitIdentity();
            nestedUnitIdentity.setModule(module);
            VersionRange versionRange = (VersionRange)artifactElement.getVersion().getValue();
            if (versionRange != null) {
                nestedUnitIdentity.setVersionRange(versionRange.toString());
            }
            nestedUnitIdentities.add(nestedUnitIdentity);
        }
        configuration2update.setNestedBundles(nestedUnitIdentities);
        return true;
    }

    private Module findModuleBySymbolicName(@NotNull String symbolicName) {
        if (symbolicName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolicName", "com/intellij/dmserver/artifacts/plan/PlanFileManager", "findModuleBySymbolicName"));
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            DMUnitDescriptor unitDescriptor = (DMUnitDescriptor)DMUnitDescriptorProvider.getInstance().processModule(module);
            if (unitDescriptor == null || !symbolicName.equals(unitDescriptor.getSymbolicName())) continue;
            return module;
        }
        return null;
    }

    public class PlanFileCreator {
        private final ModuleRootModel myRootModel;
        private final XmlFile myOldFile;
        private final XmlFile myCreatedPlanPsiFile;

        public PlanFileCreator(ModuleRootModel rootModel) {
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/plan/PlanFileManager$PlanFileCreator", "<init>"));
            }
            this.myRootModel = rootModel;
            this.myOldFile = PlanFileManager.this.getPlanFile(rootModel);
            if (this.myOldFile == null || PlanFileManager.this.getFileRootElement(this.myOldFile) == null) {
                PsiFile psiFile = PsiFileFactory.getInstance((Project)PlanFileManager.this.myProject).createFileFromText(PlanFileManager.this.getFileNameWithExt(), PlanFileManager.TEMPLATE);
                this.myCreatedPlanPsiFile = (XmlFile)psiFile;
            } else {
                this.myCreatedPlanPsiFile = (XmlFile)this.myOldFile.copy();
            }
        }

        @Nullable
        public PlanRootElement getRootElement() {
            return PlanFileManager.this.getFileRootElement(this.myCreatedPlanPsiFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() {
            PlanFileManager.this.myInFileUpdate = true;
            try {
                XmlDocument oldDocument;
                PsiDirectory planPsiDirectory = PlanFileManager.this.getPlanFileDirectory(this.myRootModel);
                if (!LOG.assertTrue(planPsiDirectory != null)) {
                    return;
                }
                CodeStyleManager.getInstance((Project)PlanFileManager.this.myProject).reformat((PsiElement)this.myCreatedPlanPsiFile);
                XmlFile oldFile = PlanFileManager.this.getPlanFile(this.myRootModel);
                XmlDocument xmlDocument = oldDocument = oldFile == null ? null : oldFile.getDocument();
                if (oldDocument != null) {
                    XmlDocument newDocument = this.myCreatedPlanPsiFile.getDocument();
                    if (!LOG.assertTrue(newDocument != null)) {
                        return;
                    }
                    oldDocument.replace((PsiElement)newDocument);
                } else {
                    planPsiDirectory.add((PsiElement)this.myCreatedPlanPsiFile);
                }
            }
            finally {
                PlanFileManager.this.myInFileUpdate = false;
            }
        }
    }
}

