/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.artifacts.DMCompositeArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMParArtifactType;
import com.intellij.dmserver.artifacts.DMPlanArtifactType;
import com.intellij.dmserver.artifacts.ManifestManager;
import com.intellij.dmserver.artifacts.PsiConfigManagerBase;
import com.intellij.dmserver.artifacts.plan.PlanFileManager;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.facet.DMCompositeFacetType;
import com.intellij.dmserver.facet.DMCompositeType;
import com.intellij.dmserver.facet.DMConfigFacet;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMFacetsSwitch;
import com.intellij.dmserver.facet.DMNestedBundlesUpdater;
import com.intellij.dmserver.facet.NestedUnitIdentity;
import com.intellij.dmserver.util.PsiTreeChangedAdapter;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMCompositeFacet
extends DMFacetBase<DMCompositeFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance(DMCompositeFacet.class);
    public static final FacetTypeId<DMCompositeFacet> ID = new FacetTypeId("dmServerComposite");
    private static final Map<DMCompositeType, DMCompositeTypeSupport> ourSupportedArtifacts;
    private final PlanFileManager myPlanFileManager;
    private final Set<DMFacetBase> myListenedNestedUnitFacets;
    private final JavaeeFacetListener myNestedUnitFacetListener;

    public static Collection<? extends ArtifactType> getSupportedArtifactTypes() {
        ArrayList<DMCompositeArtifactTypeBase> result = new ArrayList<DMCompositeArtifactTypeBase>();
        for (DMCompositeTypeSupport typeSupport : ourSupportedArtifacts.values()) {
            result.add(typeSupport.getArtifactType());
        }
        return result;
    }

    public DMCompositeFacet(@NotNull DMCompositeFacetType facetType, @NotNull Module module, @NotNull String name, @NotNull DMCompositeFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/dmserver/facet/DMCompositeFacet", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMCompositeFacet", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dmserver/facet/DMCompositeFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/dmserver/facet/DMCompositeFacet", "<init>"));
        }
        super(facetType, module, name, configuration, underlyingFacet);
        this.myPlanFileManager = new PlanFileManager(module);
        this.myListenedNestedUnitFacets = new HashSet();
        this.myNestedUnitFacetListener = new JavaeeFacetListener(){

            public void facetChanged(JavaeeFacet facet) {
                DMCompositeFacet.this.onNestedUnitFacetChanged(facet);
            }
        };
    }

    private void onNestedUnitFacetChanged(JavaeeFacet facet) {
        if (this.isDisposed()) {
            return;
        }
        if (!LOG.assertTrue(facet instanceof DMFacetBase)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> this.updateSupportWithArtifact());
    }

    public void initFacet() {
        Project project = this.getModule().getProject();
        this.getConfigurationImpl().init(project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiTreeChangedAdapter psiTreeChangeListener = new PsiTreeChangedAdapter(){

            @Override
            protected void treeChanged(PsiTreeChangeEvent event) {
                DMCompositeFacet.this.getTypeSupport().getConfigManager(DMCompositeFacet.this).onPsiEvent(event, DMCompositeFacet.this);
            }
        };
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeListener, (Disposable)this);
        this.updateFacetListeners();
        new DMNestedBundlesUpdater(project, (Disposable)this){

            @Override
            protected Collection<NestedUnitIdentity> getNestedBundles() {
                return DMCompositeFacet.this.getConfigurationImpl().getNestedBundles();
            }

            @Override
            protected void setNestedBundles(Collection<NestedUnitIdentity> nestedBundles) {
                DMCompositeFacet.this.getConfigurationImpl().setNestedBundles(nestedBundles);
            }

            @Override
            protected void dmFacetAddedOrRemoved(DMFacetBase facet) {
                Module module = facet.getModule();
                for (NestedUnitIdentity unitIdentity : DMCompositeFacet.this.getConfigurationImpl().getNestedBundles()) {
                    Module nestedModule = unitIdentity.getModule();
                    if (nestedModule != module && nestedModule != null) continue;
                    DMCompositeFacet.this.updateSupportWithArtifact();
                    break;
                }
            }
        };
    }

    public void updateFacetListeners() {
        HashSet newListenedNestedUnitFacets = new HashSet();
        for (NestedUnitIdentity unitIdentity : this.getConfigurationImpl().getNestedBundles()) {
            Module nestedModule = unitIdentity.getModule();
            if (nestedModule == null) continue;
            new DMFacetsSwitch<Object>((Set)newListenedNestedUnitFacets){
                final /* synthetic */ Set val$newListenedNestedUnitFacets;
                {
                    this.val$newListenedNestedUnitFacets = set;
                }

                @Override
                protected Object doProcessBundleFacet(DMBundleFacet bundleFacet) {
                    return new Object();
                }

                @Override
                protected Object doProcessCompositeFacet(DMCompositeFacet compositeFacet) {
                    this.val$newListenedNestedUnitFacets.add(compositeFacet);
                    return new Object();
                }

                @Override
                protected Object doProcessConfigFacet(DMConfigFacet configFacet) {
                    return new Object();
                }
            }.processModule(nestedModule);
        }
        for (DMFacetBase listenedFacet : this.myListenedNestedUnitFacets.toArray(new DMFacetBase[this.myListenedNestedUnitFacets.size()])) {
            if (newListenedNestedUnitFacets.contains((Object)listenedFacet)) {
                newListenedNestedUnitFacets.remove((Object)listenedFacet);
                continue;
            }
            listenedFacet.removeFacetListener(this.myNestedUnitFacetListener);
            this.myListenedNestedUnitFacets.remove((Object)listenedFacet);
        }
        for (DMFacetBase newListenedFacet : newListenedNestedUnitFacets) {
            newListenedFacet.addFacetListener(this.myNestedUnitFacetListener);
            this.myListenedNestedUnitFacets.add(newListenedFacet);
        }
    }

    private void updateSupportWithArtifact() {
        this.updateSupportWithArtifact(null, null);
    }

    @Override
    protected void updateSupport(ModifiableRootModel modifiableRootModel, ModulesProvider modulesProvider) {
        Module module = this.getModule();
        ModifiableRootModel rootModel = modifiableRootModel == null ? ModuleRootManager.getInstance((Module)module) : modifiableRootModel;
        this.updateFacetListeners();
        this.selectMainArtifactType().updateModuleSupport(module, this, (ModuleRootModel)rootModel, this.getConfigurationImpl());
    }

    public PlanFileManager getPlanFileManager() {
        return this.myPlanFileManager;
    }

    @Nullable
    public static DMCompositeFacet getInstance(Module module) {
        return (DMCompositeFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    @Override
    public DMCompositeFacetConfiguration getConfigurationImpl() {
        return (DMCompositeFacetConfiguration)this.getConfiguration();
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile manifestFolder = ManifestManager.getParInstance().findManifestFolder(this.getModule());
        if (manifestFolder != null) {
            result.add(manifestFolder);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/facet/DMCompositeFacet", "getFacetRoots"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DMCompositeArtifactTypeBase selectMainArtifactType() {
        DMCompositeArtifactTypeBase dMCompositeArtifactTypeBase = this.getTypeSupport().getArtifactType();
        if (dMCompositeArtifactTypeBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/facet/DMCompositeFacet", "selectMainArtifactType"));
        }
        return dMCompositeArtifactTypeBase;
    }

    private DMCompositeTypeSupport getTypeSupport() {
        return ourSupportedArtifacts.get((Object)this.getConfigurationImpl().getCompositeType());
    }

    static {
        HashMap<DMCompositeType, DMCompositeTypeSupport> supportedArtifacts = new HashMap<DMCompositeType, DMCompositeTypeSupport>();
        supportedArtifacts.put(DMCompositeType.PLAN, new DMPlanTypeSupport());
        supportedArtifacts.put(DMCompositeType.PAR, new DMParTypeSupport());
        ourSupportedArtifacts = Collections.unmodifiableMap(supportedArtifacts);
    }

    private static class DMParTypeSupport
    implements DMCompositeTypeSupport {
        private DMParTypeSupport() {
        }

        @Override
        public DMCompositeArtifactTypeBase getArtifactType() {
            return DMParArtifactType.getInstance();
        }

        @Override
        public PsiConfigManagerBase<?, DMCompositeFacetConfiguration, DMCompositeFacet> getConfigManager(DMCompositeFacet facetInstance) {
            return ManifestManager.getParInstance();
        }
    }

    private static class DMPlanTypeSupport
    implements DMCompositeTypeSupport {
        private DMPlanTypeSupport() {
        }

        @Override
        public DMCompositeArtifactTypeBase getArtifactType() {
            return DMPlanArtifactType.getInstance();
        }

        @Override
        public PsiConfigManagerBase<?, DMCompositeFacetConfiguration, DMCompositeFacet> getConfigManager(DMCompositeFacet facetInstance) {
            return facetInstance.myPlanFileManager;
        }
    }

    private static interface DMCompositeTypeSupport {
        public DMCompositeArtifactTypeBase getArtifactType();

        public PsiConfigManagerBase<?, DMCompositeFacetConfiguration, DMCompositeFacet> getConfigManager(DMCompositeFacet var1);
    }
}

