/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.DMServerInstallationManager;
import com.intellij.dmserver.integration.DMServerIntegration;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.osmorc.FrameworkUtils;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersUtil;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServerImpl;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;

public class DMProjectFacetSettingsPanel {
    private JComboBox myServerComboBox;
    private JButton myAddButton;
    private JPanel myMainPanel;
    private Project myProject;
    private boolean myInitialized = false;
    private DMServerInstallation mySelectedInstallation;
    private FrameworkInstanceDefinition mySelectedFramework;

    public DMProjectFacetSettingsPanel() {
        this.$$$setupUI$$$();
    }

    public void init(Project project) {
        ApplicationServer selectedServer;
        if (this.myInitialized) {
            throw new RuntimeException("Should be called once");
        }
        this.myInitialized = true;
        this.myServerComboBox.setRenderer(new ListCellRendererWrapper<ApplicationServer>(){

            public void customize(JList list, ApplicationServer value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getName());
                } else if (DMProjectFacetSettingsPanel.this.myServerComboBox.isEnabled()) {
                    this.setText(DmServerBundle.message("DMProjectFacetSettingsPanel.error.html-message.none", new Object[0]));
                } else {
                    this.setText(DmServerBundle.message("DMProjectFacetSettingsPanel.error.not-html.message.none", new Object[0]));
                }
            }
        });
        this.myProject = project;
        this.mySelectedInstallation = project == null ? null : FrameworkUtils.getInstance().getActiveDMServerInstallation(project);
        this.updateSelectedFramework();
        ApplicationServer applicationServer = selectedServer = this.mySelectedInstallation == null || !this.mySelectedInstallation.isValid() ? null : this.mySelectedInstallation.getOrCreateApplicationServer();
        if (selectedServer == null) {
            this.addServer(null);
        }
        for (ApplicationServer server : DMServerIntegration.getInstance().getDMServers()) {
            this.addServer(server);
        }
        this.selectServer(selectedServer);
        this.myServerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DMProjectFacetSettingsPanel.this.doSelectServer();
                }
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMProjectFacetSettingsPanel.this.doAddServer();
            }
        });
    }

    private void addServer(ApplicationServer server) {
        this.myServerComboBox.addItem(server);
    }

    private void selectServer(ApplicationServer server) {
        this.myServerComboBox.setSelectedItem(server);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void doAddServer() {
        final ApplicationServersManager.ApplicationServersManagerModifiableModel model = ApplicationServersManager.getInstance().createModifiableModel();
        ApplicationServerImpl server = ApplicationServersUtil.createNewApplicationServer((AppServerIntegration)DMServerIntegration.getInstance(), (ApplicationServersManager.ApplicationServersManagerModifiableModel)model, DMServerIntegration.getInstance().getDMServers(), (JPanel)this.myMainPanel);
        if (server == null) {
            return;
        }
        this.addServer((ApplicationServer)server);
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/facet/DMProjectFacetSettingsPanel$4", "run"));
                }
                model.commit();
            }
        }.execute();
        this.selectServer((ApplicationServer)server);
    }

    private void doSelectServer() {
        this.updateSelectedInstallation();
        this.updateSelectedFramework();
        if (this.myProject != null) {
            this.applyFrameworkSelection(this.myProject);
        }
    }

    public void applyFrameworkSelection(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/facet/DMProjectFacetSettingsPanel", "applyFrameworkSelection"));
        }
        FrameworkUtils.getInstance().setActiveFrameworkInstance(project, this.mySelectedFramework);
    }

    private void updateSelectedFramework() {
        this.mySelectedFramework = this.mySelectedInstallation == null ? null : DMServerInstallationManager.getInstance().findFramework(this.mySelectedInstallation);
    }

    public DMServerInstallation getSelectedServerInstallation() {
        return this.mySelectedInstallation;
    }

    private FrameworkInstanceDefinition getSelectedFramework() {
        return this.mySelectedFramework;
    }

    private void updateSelectedInstallation() {
        ApplicationServer server = (ApplicationServer)this.myServerComboBox.getSelectedItem();
        if (server != null && this.myServerComboBox.getItemAt(0) == null) {
            this.myServerComboBox.removeItem(null);
        }
        this.mySelectedInstallation = server == null ? null : DMServerInstallationManager.getInstance().findInstallation(((DMServerIntegrationData)server.getPersistentData()).getInstallationHome());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMProjectFacetSettingsPanel.server"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMProjectFacetSettingsPanel.add"));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

