/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMUnitDescriptor;
import com.intellij.dmserver.facet.DMUnitDescriptorProvider;
import com.intellij.dmserver.facet.NestedUnitIdentity;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.VersionUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.VersionRange;

public class VersionsRangeDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JRadioButton myAnyRadioButton;
    private JRadioButton myModuleRadioButton;
    private JRadioButton myCustomRadioButton;
    private JTextField myCustomTextField;
    private List<NestedUnitIdentity> myUnitIdentities;

    public VersionsRangeDialog(Project project, List<NestedUnitIdentity> unitIdentities) {
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DmServerBundle.message("VersionsRangeDialog.title", objectArray));
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.myAnyRadioButton);
        radioGroup.add(this.myModuleRadioButton);
        radioGroup.add(this.myCustomRadioButton);
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionsRangeDialog.this.updateUI();
            }
        };
        Enumeration<AbstractButton> radioEnumeration = radioGroup.getElements();
        while (radioEnumeration.hasMoreElements()) {
            radioEnumeration.nextElement().addActionListener(radioListener);
        }
        this.initContent(unitIdentities);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void initContent(List<NestedUnitIdentity> unitIdentities) {
        this.myUnitIdentities = unitIdentities;
        this.myAnyRadioButton.setSelected(true);
        this.myCustomTextField.setText("");
        this.updateUI();
    }

    private void updateUI() {
        this.myCustomTextField.setEnabled(this.myCustomRadioButton.isSelected());
    }

    protected void doOKAction() {
        for (NestedUnitIdentity unitIdentity : this.myUnitIdentities) {
            if (this.myAnyRadioButton.isSelected()) {
                unitIdentity.setVersionRange(VersionUtils.emptyRange.toString());
                continue;
            }
            if (this.myModuleRadioButton.isSelected()) {
                Module module = unitIdentity.getModule();
                String moduleVersion = module == null ? null : VersionsRangeDialog.findModuleVersion(module);
                String versionRangeText = VersionUtils.version2range(VersionUtils.loadVersion(moduleVersion)).toString();
                unitIdentity.setVersionRange(versionRangeText);
                continue;
            }
            if (!this.myCustomRadioButton.isSelected()) continue;
            VersionRange versionRange = VersionUtils.parseVersionRange(this.myCustomTextField.getText());
            if (versionRange == null) {
                this.setErrorText(DmServerBundle.message("VersionsRangeDialog.error.version.range.format.not.matched", new Object[0]), this.myCustomTextField);
                return;
            }
            unitIdentity.setVersionRange(versionRange.toString());
        }
        super.doOKAction();
    }

    @Nullable
    private static String findModuleVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/VersionsRangeDialog", "findModuleVersion"));
        }
        DMUnitDescriptor unitDescriptor = (DMUnitDescriptor)DMUnitDescriptorProvider.getInstance().processModule(module);
        return unitDescriptor == null ? null : unitDescriptor.getVersion();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAnyRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.VersionsRangeDialog.any"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myModuleRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.VersionsRangeDialog.take.from.module"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCustomRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.VersionsRangeDialog.custom"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCustomTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

