/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.obr;

import com.intellij.dmserver.libraries.obr.Column;
import com.intellij.dmserver.libraries.obr.JTableWrapper;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GrayableTableWrapper<T, C extends Column<T>>
extends JTableWrapper<T, C> {
    public GrayableTableWrapper(C[] columns) {
        super(new JBTable(){

            @NotNull
            public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
                if (renderer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/dmserver/libraries/obr/GrayableTableWrapper$1", "prepareRenderer"));
                }
                Component c = super.prepareRenderer(renderer, row, column);
                Color background = c.getBackground();
                if (background == null || !background.equals(this.getSelectionBackground())) {
                    c.setBackground(((GrayableTableModel)((Object)this.getModel())).isCellEnabled(row, column) ? this.getBackground() : UIUtil.getPanelBackground());
                }
                Component component = c;
                if (component == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/libraries/obr/GrayableTableWrapper$1", "prepareRenderer"));
                }
                return component;
            }
        }, columns);
    }

    @Override
    protected GrayableTableModelBase createTableModel() {
        return new GrayableTableModelBase();
    }

    protected class GrayableTableModelBase
    extends JTableWrapper.JTableWrapperModel
    implements GrayableTableModel {
        protected GrayableTableModelBase() {
            super(GrayableTableWrapper.this);
        }

        @Override
        public boolean isCellEnabled(int row, int column) {
            return true;
        }
    }

    private static interface GrayableTableModel {
        public boolean isCellEnabled(int var1, int var2);
    }
}

